# Changelog

## v6.5.3 (2025-05-28)
In memory of Matej Vrba, a great developer who left too soon.
### Added
- Added (except for SmartFlex and SmartMotion with modules PLS8-E and PHS8-P)
  possibility to synchronize date and time with the cellular network:
    - For automatic synchronization, select *Synchronize clock with cellular
      network* in the *NTP Configuration* page.
    - For manual synchronization, select *Query cellular module* in the *Set
      Date and Time* page.
- Added logging for AT, QMI, and MBIM communication with the cellular module.
  To enable, check *Enable debugging* in the *Mobile WAN Configuration* and
  then increase *Minimum Severity* in the *Syslog Configuration* to *Debug*.
- Added expert configuration options for Mobile WAN, not shown in the GUI:
    - Set `PPP_TOLERATE_NO_SIM=1` to disable module restarts if connectivity is
      enabled but SIM is missing. After inserting the SIM, the user must reboot
      the router manually.
    - Set `PPP_TOLERATE_NO_SIGNAL=1` to disable module restarts if the signal
      has been lost. As a side effect, the SIM switching will not work.
- Added default APN for PLMN 2320319, 23203189, and 90140571.
- Added support for ICR-25/264x with LE910C4-WWXD.
- Added support for ICR-41/426x with Quectel RM500U.
- Added support for ICR-447x with Telit FN990.
- Added terminfo database file for easier integration of screen-oriented
  router apps, such as `mc` or `lynx`.
### Changed
- Increased the maximum number of *Remote subnets* in the *WireGuard Tunnel
  Configuration* from 4 to 32. Unused items are automatically hidden.
- Upgraded strongSwan to version 6.0.1 and added new ciphers to the *IPsec
  Tunnel Configuration*:
    - CAMELLIA256CCM128 and CHACHA20POLY1305 added to *ESP Encryption*.
    - DH groups 24 (modp2048s256), 28 (ecp256bp), 29 (ecp384bp), 30 (ecp512bp),
      31 (curve25519), 32 (curve448), 36 (mlkem768), and 37 (mlkem1024) added to
      *IKE DH Group* and *PFS DH Group*. The configuration fields now also show
      the group names.
    - Fixed certificate validation, so the router will reject certificates that
      do not match the configured *Local ID* or *Remote ID*.
- Upgraded OpenSSH to version 10.0. This fixes several minor security
  vulnerabilities and a temporary connection rejection after a previous session
  expired unauthenticated.
- Modified *Carrier* selection options in the *Mobile WAN Configuration*:
    - *Outside North America* is now available on all platforms and enables
      a global cellular configuration.
    - Individual operators such as *AT&T* are listed only on products certified
      for the NAM region, i.e. SL302, SR305/310, ICR-2x41, ICR-3211/3241,
      ICR-4434/4461, and ICR-4171/4271.
    - *North America, Generic* is also available and enables a generic North
      America (PTCRB) configuration (when supported), or a global configuration.
    - *automatic detection* was renamed to *North America, Autoselect*. It now
      either selects a specific network operator configuration automatically or
      falls back to a generic North America configuration.
- Enhanced Web administration with a color stripe to distinguish between
  standard routers (green stripe) and S1 routers (orange stripe).
- Modified *System Information* on the *General Status* page to display the
  *Product Type* by default and the *Hardware UUID* only when *More Information*
  is requested.
### Removed
- Removed (except for SmartStart) settings *Use CD as indicator for TCP
  connection* and *Use DTR as control of TCP connection* from *Expansion Port
  Configuration*. These settings do not apply to other products as the DTR/DCD
  signals are available on SmartStart products only.
- Removed support for WiFi SD8997, which is not used in any product.
- Removed default APN for PLMN 26003.
### Fixed
- Fixed a cellular module lock-up on ICR-27/2800 that might occur after an
  unsuccessful connection change.
- Fixed availability of the *Follow STA Radio Settings* option in the WiFi AP
  Configuration. It appears only when supported by the WiFi module, newly also
  on all ICR-41xxW/42xxW. It is now supported by all products, except SL3xx
  with SG901-1059B, and ICR-2xxxW with AW-CM358.
- Fixed handling of the *PAP or CHAP* option in the Mobile WAN *Authentication*
  on ICR-2437 with ML620, and SL306 with ME909. The username/password was
  not set correctly in case *PAP or CHAP* was selected.
- Optimized network selection and attachment on ICR-2437 with ML620. The
  implementation now uses Unitac-specific AT commands recommended for better
  reliability and performance. This change works best with the latest Unitac
  firmware `0.3.4.1/ML620EUV14_RELEASE_20250516`.
- Fixed changing of APN settings on ICR-4133/4233 with FM101. Previously a
  module restart was required in some situations.
- Fixed possibility to *Set Date and Time* via *Query NTP server*. Invoking this
  in the 6.5.2 firmware caused a *Set Date and Time update failure*.
- Fixed occasional FTP server errors with message *failed to map segment from
  shared object*, which could cause login failures.
- Fixed wrong Wi-Fi chipset model name displayed for ICR-2xxxW with AW-CM358.
- Fixed several issues of the Web administration:
    - Fixed a JavaScript error on the *Module Switching* page of SmartMotion
      products.
    - Fixed an *Invalid input* error on *NAT* and *NAT6* pages in an unlikely
      situation when the user was logged-in using a default password.
- Fixed handling of Mobile Country Codes with leading zeros by products with
  PLS83 modules.

## v6.5.2 (2025-03-03)
### Added
- Added support for DNSSEC queries. The router now enables LAN devices to
  query DNS records protected by cryptographic signatures.
- Added support for IP address ranges to IPv4 and IPv6 Firewall, allowing
  *Source* or *Destination* to be e.g. `192.168.1.100-192.168.1.200`.
- Added *Any* to the IPv4 and IPv6 *Static Routes* *Interface* selection. This
  allows users e.g. to setup static routes towards a GRE tunnel.
- Added *Interface* configuration to *VRRP* enabling users to select *ETHx* or
  the Ethernet *Bridge*.
- Added *MTU* configuration to *Wireguard*.
- Added password quality indicator to L2TP and PPTP configurations.
- Extended *Network Status* to display currently selected *Backup Routes*.
- Implemented command `service syslog reload` to enable rotation of log files.
- Added default APN for PLMN 26219.
### Changed
- Several lists are now hiding unused items and allow a larger number of items.
  Initially only 2 items are displayed, but two more will appear automatically
  once the last item is filled.
    - The maximum number of *Firewall* rules increased from 16 to 32 rules.
    - The maximum number of *NAT* rules increased from 16 to 64.
    - The maximum number of *Static Routes* increased from 8 to 32.
    - The maximum number of *static DHCP leases* for Ethernet and VLAN
      increased from 6 to 32.
- Modified WiFi AP configuration to hide invalid combinations of configuration
  parameters. Only valid options are allowed.
    - The *Channel* selection offers legal channels supported by the hardware
      only. To see a correct list the *Country Code* must be already applied.
    - 5 GHz and 6 GHz channels are no longer offered if country code 00 is set.
      A warning is displayed this is due to legal restrictions.
    - Bandwidths with no channels available are no longer offered.
    - Renamed an ill-named `WIFI_AP_HT40` settings item to `WIFI_AP_BANDWIDTH`.
- Changed (except for ICR-20,24,25/2600) internal NTPv4 implementation: ntp was
  replaced by chrony 4.6.1, which provides higher stability and reliability.
- Disabled TCP timestamps (set net.ipv4.tcp_timestamps=0) for security reasons.
- Modified IPv6 address fields to accept upper-case characters.
- Modified removal of sensitive configuration parameters from reports. Now only
  options ending with `PASS`, `PASSPHRASE` and `PASSWORD` are removed. Previously
  we removed all options with substring `PASS`, including e.g. `PASSIVE`.
- Shown *GRE* *Pre-shared Key* as a plain text. It is not a sensitive information.
### Removed
- Removed the *802.1X* option from WiFi AP Configuration. This was ill-named
  and enforced an WEP encryption with static keys, which is an extremely
  insecure option. The 802.1X protocol in combination with the WPA encryption
  is still supported for the *WPA-Enterprise* options.
### Fixed
- Fixed cellular modem failures when downloading large files, affecting PLS8,
  PLS83, MC7304, LM960, MPL200, EC25, BG96, and FM101. Previously, the cellular
  modem could restart under a heavy load causing transmission failures.
- Fixed several WiFi issues:
    - Fixed authentication on ICR-2xxxW routers, particularly authentication
      using WPA3-PSK and to some AP, notably Ubiquiti UniFi 6 Lite.
    - Fixed ability to set 6GHz WiFi channels 3, 5 or 7. Previously the error
      *Error during HOSTAPD configuration update.* was displayed.
    - Prevented firmware reboot when connecting to a 5 GHz WiFi AP with
      ICR-2xxxW routers.
    - Fixed WiFi STA termination on ICR-4400 devices. The bug caused termination
      of the first WiFi connection after calling `service wifi2 stop` or
      `service wifi restart`.
    - Fixed visibility of the *WPA PSK Secret* in both WiFi AP and STA
      configuration.
    - Fixed broken field validation JavaScripts on platforms limited to the `00`
      country code.
    - Fixed automatic pre-filling of configuration fields after applying WiFi
      STA settings on ICR-2xxx routers. Previously, the fields were empty when
      the user clicked *Back* after having applied changes.
- Fixed NTP availability after a loss of Internet connectivity. Previously the
  NTP terminated when the connectivity was lost and never started again.
- Fixed availability of NAT64 on ICR-2000, ICR-2400 and ICR-2500/2600.
- Fixed SSH logoff after session timeout. Previously the connections were always
  closed after 1 hour of inactivity regardless the *Session Timeout* value.
- Fixed backup of *SSH Public Keys* and *Secret Keys* for *Two-Factor Auth*.
  Previously these settings were not included in the *Backup Configuration*
  and were lost after firmware upgrade.
- Fixed incorrect termination of GPS module, which caused unexpected error
  messages and frozen location info.
- Fixed several issues of the Web administration:
    - Fixed a malformed Content-Security-Policy header.
    - Fixed broken field validation JavaScripts for non-admin users.
    - Improved security and HTML validity. The pages are now more HTML standard
      compliant and better check input values.
- Fixed a harmless `mtd_lock error` message on ICR-2xxx with a persistent log
  enabled.

## v6.5.1 (2024-11-28)
### Added
- Added configuration of *Minimum Severity* to the *Syslog* service
  configuration on all platforms. This can be used to decrease or increase
  the amount of system log messages.
- Enabled disabling of USB ports on all platforms for security reasons.
  Previously this has been supported on ICR-4400 devices only.
- Added support for `postinstall` scripts in RouterApps. This script is called
  after the RouterApp is installed, or upon first start after upgrade.
- Added support for Telit LE910C4-WWXD used in ICR-2442.
- Added support for Telit PLS83-W mPCIe used in ICR-2545 and ICR-2645.
- Added support for products ICR-27xx-S1.
### Changed
- Disabled NAT64 by default and added a possibility to explicitly *Enable NAT64*
  to the *IPv6 NAT Configuration*. Previously was the NAT64 always enabled.
- Added a default firewall rule for NAT64. This rule is disabled by default.
- Replaced the Ecdysis NAT64 implementation with
  [Jool](https://nicmx.github.io/Jool). The Ecdysis has been unmaintained for
  more than 10 years. Note that the Jool behaviour is slightly different:
    - Only incoming traffic can be translated using NAT64, traffic originating
      from the router won't be translated;
    - Instead of virtual network interface, Jool is using netfilter, so there
      is no `nat64` interface;
    - `null0` virtual interface and relevant entry in routing table was added
      to ensure routing table always contains entry matching nat64 prefix;
    - Jool drops all incoming packets with source IPv6 address matching NAT64
      prefix, it is not recommended to have multiple routers with NAT64 enabled
      on multiple routers in series.
- Fine tuned configuration of hostapd and wpa_supplicant for better performance:
    - Lowered re-scanning delay when WiFi follow STA is enabled to 30 seconds;
    - Added proper disconnection from WiFi network when stopping WiFi station;
    - Added ignoring of old WiFi scan results to prevent connections with
      incorrect settings;
    - Added failsafe termination of hostapd if it fails to shutdown in time;
    - Enabled background radar detection;
    - Fixed failure when stopping AP-STA daemon;
    - Added support for Operating Channel Validation (excl. Laird SU60-SIPT).
- Upgraded the ca-certificates bundle to the version from 2024-09-24.
- Upgraded curl to version 8.11.0. This fixes several minor security issues.
- Renamed *User Administration* page to *Manage Users* for a better consistency.
- Allowed invocation of `date`, `dmesg`, `faillock`, `sms` and `slog` commands
  with elevated privileges (`sudo`) on -S1 platforms.
- Removed commands `ftpput` and `telnet` from the -S1 platforms due to security
  concerns.
- Encrypted the -S1 firmware image. The version 6.5.0 must be installed first
  before upgrade.
### Fixed
- Fixed *Emergency Factory Reset*. On routers with firmware 6.5.0 and a
  `Pxxxxxxxxh` password the emergency factory reset wrongly initialized the
  default password to `PN/Ah`.
- Fixed the *Certificate* field in *HTTP Configuration* to accept a full
  certificate chain. Previously only the first certificate was loaded, ignoring
  any extra chain certificates.
- Fixed display of existing *SSH Public Key* on the *Modify User* page. With
  firmware 6.5.0 this field was empty although a key has been configured.
- Fixed removal of SSH and two-factor authentication keys after a configuration
  reset. Previously, the user-uploaded keys were not removed.
- Fixed reliability of syslog restart. The syslog service in some situations
  in 6.5.0 did not start again after being stopped.
- Improved robustness of QMI and MBIM communication. Previously, the
  cellular communication might get blocked indefinitely when a faulty cellular
  module failed to receive commands.
- Several WiFi issues:
    - Fixed *Auto* WiFi channel selection (ACS) on SG901-1059B and TI WL1837MOD
      in SmartStart, SmartFlex and SmartMotion products;
    - Fixed failures during restart of AzureWave AW-CM358 on ICR-2000;
    - Fixed ability to use WiFi channel 13 on ICR-4400 with Compex WLE900VX-I.
- Fixed the DNS64 address resolution when only an IPv4 network is available but
  the destination supports IPv6. Previously, the NAT64 address was always
  returned, without trying to retrieve the IPv6 address via IPv4.
  Now, the router will always try to resolve the IPv6 address and use NAT64 only
  when the destination supports IPv4 only.
- Fixed cellular connections to IPv6-only APN. Previously, even when the
  *IP Mode* was set to IPv6 the device was reported as IPv4v6 to the cellular
  network.
- Fixed online installation of RouterApps on -S1 platforms.
- Fixed admin users the read access to settings files on -S1 platforms.

## v6.5.0 (2024-10-08)
### Added
- Added *VLAN* tagging (IEEE 802.1Q) support.
  The *PPPoE* parameters *VLAN Tagging* and *VLAN ID* were replaced by the
  possibility to have a VLAN as the PPPoE *Interface*.
- Added *Sites* (URL) blocking to the *Firewall* configuration.
- Added configuration of a *Secondary DNS Server* to the *Ethernet*,
  *Mobile WAN*, *PPPoE* and *WiFi Station*.
- Added (except for ICR-20,24,25/2600) more NTP Configuration options:
  *Tertiary NTP Server*, *Maximal Polling Interval*, and *Enable fast initial
  synchronization*.
- Added (except for ICR-20,24,25/2600) more Syslog Configuration options:
    - Ability to send *Mark Messages* for syslog availability checks;
    - Ability to forward syslog messages via TCP and SSL/TLS, optionally with
      certificate based authentication
      (in fact, the Secure Syslog Router App was integrated into the firmware).
- Added an "eye" icon to password fields to toggle password visibility.
- Added a complexity indicator to configuration fields where user creates
  a new password of a WiFi PSK.
- Added information about last successful and failed logins. This is displayed
  after each SSH login and also in the *Security Information* section on the
  *General Status* page.
- Added *Free space* indication to the *System Information* and *Router Apps*
  pages.
- Added *Connections* status page showing a list of active connections. The page
  can be displayed via a link at the bottom of *Network Status*.
- Added support for the Ed25519 SSH key. It provides better security and shorter
  creation time. On -S1 platforms it is used by default.
- Added options to configure CA certificate validation for *Automatic Update*.
- Added auto-redirection to the login page when the HTTP *Session Timeout* expires.
- Added warning to the Web GUI when a Web browser does not support JavaScript.
- Added AT91bootstrap verification to complete the secure boot chain on -S1 and
  disabled the OTP emulation mode.
- Added loading of FIT configs of -S1 based on the board-id.
- Added password initialization from the -S1 OTP memory and additional check to
  fail booting when the OTP memory cannot be read.
- Added product identifiers to the standard `/sys/class/dmi/id/*` tree.
- Added new variables to /etc/os-release:
    - VARIANT indicates a specific product variant (S1 or 1N);
    - ICR_FEATURES can contain HAS_INSECURE_OPTIONS, HAS_INTEGRITY or
      HAS_LARGE_STORAGE.
    - SUPPORT_END (on -S1 platforms) is set to one year after the firmware release.
- Added Advanced Intrusion Detection Environment (AIDE) to -S1 platforms.
- Added more logging of administrative actions, such as firmware upgrade or
  configuration backup and restore.
- Added `su` and `whoami` commands to -S1 platforms.
- Added support for encrypted firmware images on -S1 platforms.
- Added a favicon to the Web administration.
### Changed
- Heavily enhanced user management for better security of all platforms:
    - User-related configuration options have been merged into a single dialog:
      *Manage Users* for admin roles and *Modify User* for user roles.
    - Passwords have to follow configurable complexity levels (very weak, weak,
      good, strong). Standard platforms require at least 6 characters (very weak),
      -1N and -S1 require at least 12 characters (good).
    - Passwords can be configured to expire after a default time period.
    - Users currently logged in can change own password only after entering the
      previous password.
    - Initial passwords and passwords set by the admin are expired by default
      and have to be changed upon first login.
    - Password change notifications can be delivered via e-mail or SMS.
    - Account lockout after unsuccessful login attempts now applies also to SSH
      and possibly other login methods.
    - Two-factor authentication can be configured using a QR code.
    - Uploaded file for the *Secret Key* is now limited to 512 bytes.
- Renamed *PAM* service configuration to *Authentication Configuration* and added
  multiple options:
    - The fail-lock parameters (*Lock Account After*, *Count Fails For*,
      *Unlock After*), on -1N and -S1 required, otherwise optional.
    - Desired password complexity (*Force Password Complexity*)
    - Delay between two login attempts (*Delay After Fail*)
- Enhanced WiFi AP *Channel* selection:
    - *Auto* channel selection (ACS) is now (except for SmartStart, SmartFlex
      and SmartMotion) supported and enabled by default.
    - The selection box only includes channels supported by the WiFi module and
      selected *Country Code*. After changing the country code you have click
      *Apply* to see the corresponding channels.
- Removed *PSK file* option from the *WPA PSK Type* in the Wi-Fi Station
  configuration. Use the *256-bit secret* option, which behaves exactly the same.
- Removed Wi-Fi AP/Station *Extra Options* from -1N and -S1 platforms due to
  security concerns.
- Changed default settings for better security. These settings can be modified
  via Web administration.
    - Enabled both IPv4 and IPv6 firewall by default, allowing all traffic
      originated by the default 192.168.1.0/24 network.
    - Disabled SNMP by default.
- Added possibility to configure *FTP Helper* and *PPTP Helper* ports in the IPv4
  and IPv6 *NAT* configuration. Previously the helpers were enabled on all ports,
  which might disrupt non-FTP or non-PPTP traffic.
- Disabled handling of ICMP redirects (accept_redirects) for higher security.
- Changed Syslog *Size Limit* units from lines to kibibytes (KiB). The lines were
  limited to 1024 characters, so this should not affect the maximum file size.
- Disabled SHA1 related ciphers in SSH service. These ciphers are considered quite
  insecure. The same restricted set of ciphers now applies also to the SSH client.
- Restricted the list of commands executable with `sudo` on -S1 platforms and moved
  the `admin` user to a dedicated non-root group on -S1 platforms.
- Switched to a full implementation of the `passwd` command that has now more options.
- Removed `chpasswd` command from -S1 platforms.
- Modified the [Content-Security-Policy](https://content-security-policy.com/)
  HTTP header for better security:
    - Removed 'unsafe-eval' option, so execution of the `eval()` function is now
      prohibited. Executing JavaScript from a string is an enormous security risk.
    - Removed 'unsafe-inline' option on -S1 platforms and implemented a nonce-based
      mechanism for JavaScript and CSS security protection.
- Renamed ICR-283x-S1 to ICR-28xx-S1.
- Switched -S1 platforms to a new product OID based on ICR numbers,
  e.g. `.1.3.6.1.4.1.30140.1.2834` for ICR-2834.
- Switched (except for ICR-20,24,25/2600) to a standard NTPv4 implementation
  based on ntp 4.2.8p18.
- Upgraded to Linux Kernel version 6.1.90. This fixes few minor security issues.
- Upgraded OpenSSL to version 3.0.15 to fix few minor security issues.
- Upgraded OpenSSH to version 9.8, mainly due to CVE-2024-6387.
- Upgraded OpenVPN to version 2.6.12 to fix few minor security issues.
- Upgraded strongSwan to version 5.9.14.
- Upgraded hostapd and wpa_supplicant to version 2.11 and optimized its
  configuration for a more reliable connectivity.
- Disabled DES, 3DES and MD5 in *IPsec* configuration on -S1 and -1N platforms
  for better security.
- Changed module defaults invocation to be called also after the first start of
  the device.
- Moved SSH key generation to device startup to make the initial setup of the
  SSH service faster.
- Moved `/usr/ssl/*` to `/etc/ssl/*` for better consistency with the FHS and
  better security of -S1.
  On -S1 moved also cellular statistics, `tfa` and `authorized_keys` to `/var/lib`.
- Modified the welcome page to be showed only when a /var/data/*/.welcome file
  doesn't exist.
- Switched to initramfs on -S1 platforms for more stability of the booting
  process.
- Modified the `fwupdate` command to delete the source `.bin` file during
  upgrade when stored in the `/tmp`. This is to preserve more space for upgrade.
- Integrated the Wi-Fi regulatory database to the Linux Kernel image.
- Increased size of the Linux Kernel ring buffer for better logging.
- Removed unsupported *GPRS* option from routers with the EC25-AF module.
### Deprecated
- Command `gsmsms` is deprecated and will be removed in the version 6.6.0. The
  command `sms` should be used instead.
### Fixed
- Fixed WiFi connectivity issues on multiple platforms, including ICR-3200,
  ICR-4100/4200 and ICR-4400.
- Fixed *Connect* on the *Scan* page for SSID with leading or training space.
- Fixed device reboots when startup took more than 60 seconds, e.g. due to
  generation of a large key.
- Fixed display of HTTP 404 pages. These are now displayed to authenticated users
  only for security reasons.
- Fixed missing mobile WAN status on ICR-2734 (PLS83-EP).
- Fixed IPv6 firewall to allow DHCPv6 traffic.
- Fixed the condition to start the SLAAC IPv6 autoconfiguration. It is now
  correctly started only when the network mask is 64 bits.
- Fixed hard factory reset on -S1 platforms to correctly wipe the varfs partition.
- Fixed access of admin users to /var/data.
- Increased randomness of the dynamic *Automatic Update* window.
- Avoided concurrent SSH key generation when invoked multiple times.
- Fixed version comparison to ignore metadata per https://semver.org/spec/v2.0.0.html.
- Enhanced robustness of users restore. When an erroneous backup would lead to
  a broken admin account, a standard admin with a default password is restored.
- Enhanced robustness of the firmware upgrade to prevent malicious users from
  injecting custom files to the upgrade process.
- Fixed authentication of -S1 RouterApps.
- Fixed config restore of -S1 RouterApps.
- Fixed pre-installation checks and deletion of erroneous -S1 RouterApps.
- Fixed jq version in the list of licenses.

## v6.4.3 (2024-08-16)
### Fixed
- Fixed 5G NSA technology detection and carrier selection on ICR-4[12]71 devices
  with Telit FN990.
- Fixed deletion of a backup partition after manufacturing. This may have caused
  manufactured routers to have a wrong initial IP address (192.168.1.101-104).

## v6.4.2 (2024-05-29)
### Added
- Added platform RBv2i-S1 and product ICR-283x-S1. This is a new product in
  development that provides an increased system integrity through secure boot,
  read-only filesystem, dm-verity and configuration hashes.
- Added the `jq` command for a better manipulation of JSON files.
- Added cryptsetup to ICR-2000-S1 routers and to the ltib host utilities used to
  build all platforms. This enables creation and attachment of dm-verity
  protected images.
- Added custom listening *Port* to the *SSH Configuration*.
- Added highlighting of the *Two-Factor Authentication* menu item on ICR-xxxx-1ND
  routers when the 2FA is not enabled.
### Changed
- Upgraded the Laird SU60 WiFi driver on ICR-3200 routers to version 11.171.0.24.
  This fixes a lot of WiFi connectivity issues on these routers. This might
  affect behaviour of the WiFi module in some situations:
    - When used as an AP and a Station, the AP will not accept any clients if
      the Station is not connected.
- Disabled WiFi WEP encryption on ICR-4100/4200 routers as the Atheros driver
  (ath11k) no longer supports it.
- Hardened the SSH service on ICR-xxxx-1ND routers to meet all requirements of
  the [ssh-audit](https://github.com/jtesta/ssh-audit) tool. Particularly, the
  required RSA key size has been increased to 3072, several insufficiently secure
  ciphers were disabled, and the maximum session timeout was decreased to 900s.
- Modified the filesystem hierarchy for a better compliance with the
  [Filesystem Hierarchy Standard](https://refspecs.linuxfoundation.org/FHS_3.0/fhs-3.0.html):
    - Added `/run` directory for run-time variable data. On all routers (except
      ICR-2000-S1) is this idential to `/var`.
    - Moved `/home/httpd` to `/usr/share/www` and added a symlink to the original
      location to preserve backwards compatibility.
- Modified RouterApp selection to accept filenames corresponding to the current
  platform only, e.g. ICR-4100/4200 routers require names ending with `.v4i.tgz`.
- Enabled CONFIG_TCP_MD5SIG in Linux kernel. This enables the FRR RouterApp to
  set the TCP MD5 option.
- Improved usability of the *Set Real Time Clock* dialog: renamed it to
  *Set Date And Time*, added a radio button to choose between different methods,
  and a quick input validation.
- Upgraded at91bootstrap to version 4.0.8 and U-Boot to version 2021.04 on
  all ICR-2000 routers. This enables secure boot on the ICR-2000-S1 routers.
- Upgraded u-boot-tools used to build all platforms to version 2021.04. This
  enables creation of signed firmware images for ICR-2000-S1.
- Upgraded the ltib's internal popt library to version 1.7. Users that build
  custom `ltib` binaries need to rebuild the RPM database by invoking
  `sudo rm -rf /opt/ltib && rm .lock_file .tc_test_gcc-icr* && ./ltib --hostck`.
### Fixed
- Fixed a crash during the high-volume data upload via cellular on some
  ICR-4100/4200 routers.
- Enabled two-factor authentication on ICR-4100/4200 that was erroneously disabled.
- Fixed an errornous html text displayed when a two-factor authentication failed.
  This occurred only when *Debug* was enabled on *PAM Configuration* page.
- Fixed the *CPU Usage* value in the *System Information* section. The firmware
  erroneously reported the average load instead.
- Fixed an SSH failure after an increase of the key strength requirements.
- Removed broken links to WiFi settings displayed when the WiFi configuration was
  successfully updated but not all APs or STAs were working.

## v6.4.1 (2024-03-27)
### Added
- Added support for WiFi 6 and 6E (802.11ax) on the ICR-4100/4200 platforms. It
  can be enabled by setting *HW Mode* to *IEEE 802.11ax* or *IEEE 802.11ax@6GHz*.
- Added *Module Information* to *WiFi Status* page that indicates chip, firmware
  and a list of supported modes.
- Added ability to *disable external USB Port* on ICR-4400 platforms. This
  increases device security. On ICR-4461-1N is the external USB always disabled.
- Added `net-snmptrap` and `net-snmpinform` commands for sending SNMP v1/v2c/v3
  notifications.
- Added `less` command for an easier command-line maintenance.
- Added `ICR_PLATFORM`, `ICR_COUNTRY` and `ICR_PRODUCT_OID` fields in the
  `/etc/os-release` file. This information is used by some Router Apps.
- Added `.ver` file in the firmware `.bin` tar file for a better identification
  of the firmware file.
- Enabled wakeup after the shutdown due to critical temperature on ICR-4100/4200.
- Added support for Telit FN990 (ICR-4171/4271).
### Changed
- Renamed `version.txt` to `CHANGELOG.md` and changed the format to Markdown,
  based on the https://keepachangelog.com/en/1.1.0/ guidelines.
- Lowered minimum allowed *Lease Time* to 5 seconds for Ethernet and WiFi
  *dynamic DHCP leases* to enable connection of special devices.
  The internal DHCP Client still accepts lease times of at least 20 sec.
- Increased size of the overlay filesystem on ICR-4100/4200 platforms.
- Upgraded dnsmasq to 2.90 to fix CVE-2023-28450 and CVE-2023-50387.
- Upgraded zlib to 1.3.1. This is due to CVE-2023-45853, which does not affect
  our products, but automated scanners were nevertheless unhappy.
### Fixed
- Reclaimed all free space on the root filesystem after firmware upgrade on the
  ICR-4400 platform. After upgrade the partition was shrinked to the installed
  files only. The free space can be reclaimed manually by calling `resize2fs`.
- Fixed detection of the WPA3 encryption in the WiFi scan results. In some cases
  the WPA3 was not detected correctly.
- Fixed filesystem privileges so the DHCP server can create lease files.
- Fixed online installation of RouterApps to correctly display 100+ items.
- Fixed detection of Ethernet ports in the PPPoE *Interface* configuration. In
  some cases the devices with 2 Ethernet ports offered 3 ports.
- Fixed return code of `/etc/init.d/wifi1 scan` scripts to return 1 on failure.
  This also fixes occasional blank screens in GUI during WiFi scanning.
- Fixed enabling/disabling of *IP Address* and *Subnet Mask / Prefix* in the
  configuration of WiFi STA IPv6.

## v6.4.0 (2024-02-07)

- Added automatic WiFi channel selection
- Added CPU & Memory Usage information
- Added Router Apps store functionality
- Added support for SIP ALG functionality
- Added date information to generated email
- Added OID for the current profile
- Added build IDs to generated binaries
- Added external debugging symbols for proprietary FW sources
- Added option to set time from browser
- Added information about BIN2 and BIN3 to SNMP
- Added custom field to SNMP
- Added new line to DynDNS status page
- Improved check whether hostapd is running
- Increased buffer for licenses
- Enabled CGROUP_BPF in the Linux kernel
- Displayed current working directory in BusyBox shell
- Removed support of UART data bits 5 and 6
- Fixed issue with Bridge on Eth2
- Fixed crash of totd daemon during DoS Attack
- Fixed minor issue with VRRP ping interval
- Fixed minor issue with SNMP Get for the serial number
- Fixed minor issue with docker daemon
- Fixed out of memory issue caused by libthread_db.so library
- Fixed Ntpdate buffer overflow
- Fixed regulatory domain setting on Laird WiFi modules
- Fixed U-boot compilation when libmd library is installed
- Fixed sending mobileReportPeriod value via SNMP
- Added PPP_REGISTRATION_TOUT parameter to configure the cellular registration timeout
- Upgraded Linux kernel to version 6.1
- Upgraded OpenSSL to version 3.0.12
- Upgraded program iproute2 to version 6.1
- Upgraded program strongSwan to version 5.9.13
- Upgraded program curl to version 8.4.0
- Upgraded program Net-SNMP to version 5.9.4
- Upgraded program OpenSSH to version 9.6p1
- Upgraded program OpenVPN to version 2.6.8
- Updated wireless regulatory database
- Upgraded ethtool to version 6.5
- Upgraded the iw to version 5.19
- Added the xxd command
- Password fields in GUI no longer allow copy-paste operations
- Syslog service allows DNS names
- System passwords are now stored using SHA-512
- Users can login to the console using SSH keys
- Increased number of shown syslog lines to 50
- Added WiFi Scan with simple results and expandable "more info"
- Added "Maximum Segment Size clamping" option to PPPoE
- Added SNMP OID for new products
- Changed maximum size of /tmp filesystem to 50% of the RAM size
- Added a configurable SECLEVEL for OpenVPN
- Changed shade of the blue color in the login dialog
- Fixed ability to install iptables extensions

## v6.3.12 (2024-03-27)

- Fixed crash of autoupdate
- Added custom field to SNMP
- Added build flags to /etc/os-release

## v6.3.11 (2024-02-07)

- Added automatic WiFi channel selection
- Added CPU & Memory Usage information
- Added support for SIP ALG functionality
- Added date information to generated email
- Added OID for the current profile
- Added build IDs to generated binaries
- Added external debugging symbols for proprietary FW sources
- Added option to set time from browser
- Added information about BIN2 and BIN3 to SNMP
- Added custom field to SNMP
- Improved check whether hostapd is running
- Increased buffer for licenses
- Removed support of UART data bits 5 and 6
- Fixed crash of totd daemon during DoS Attack
- Fixed minor issue with VRRP ping interval
- Fixed minor issue with SNMP Get for the serial number
- Fixed minor issue with docker daemon
- Fixed out of memory issue caused by libthread_db.so library
- Fixed Ntpdate buffer overflow
- Fixed U-boot compilation when libmd library is installed
- Fixed sending mobileReportPeriod value via SNMP
- Added PPP_REGISTRATION_TOUT parameter to configure the cellular registration timeout

## v6.3.10 (2023-04-28)

- Resolved GRE keepalive via sysctl instead of by kernel patch
- Upgraded program curl to version 8.0.1
- Replaced setting accept_dad in kernel patch by sysctl configuration
- Fixed applying settings to any Ethernet configuration
- Fixed LAN interface failure when using PPPoE line
- Updated ca-certificates
- Fixed mwan IPv6 connection issue
- Added FirstNet warning to UI page Router Apps
- Fixed totd due to CVE-2022-34294
- Upgraded library OpenSSL to version 1.1.1t
- Fixed NTP service not updating RTC clock
- Stopped unnecessary update of system log on web
- Moved ADC channels naming to DTS
- Replaced silego watchdog driver by gpio watchdog
- Replaced national driver by dp83848
- Fixed default values not matching enum options in WiFi configuration
- Fixed cmd 0x25f error in kernel log
- Fixed issues on Quectel RM520N-GL module with the newest FW
- Improved work with PoE on the v4 platform
- Fixed WiFi AP not responding to authentication
- Fixed tc segmentation fault
- Added other licenses info to FW info page
- Upgraded program BusyBox to version 1.36.0

## v6.3.9 (2023-01-04)

- Fixed reading information about mobile connection via SNMP
- Fixed occasional IPsec hang when terminating connection
- Improved security by running VRRP in unprivileged mode
- Upgraded library OpenSSL to version 1.1.1s
- Fixed CVE-2022-45934 in Linux kernel
- Fixed CVE-2022-30065 in program BusyBox
- Fixed CVE-2022-44792 in program Net-SNMP
- Fixed CVE-2022-44793 in program Net-SNMP

## v6.3.8 (2022-12-02)

- Added support of WiFi interfaces to SNMP
- Added support of switch physical interfaces to SNMP
- Added support of product revision to web interface and SNMP
- Added password validation to CGI scripts
- Improved security by running several services in unprivileged mode
- Increased timeout for sending SMS to 20 seconds
- Increased timeout for network registration for Webbing SIM cards to 5 minutes
- Disabled weak ciphers MD4 and RC4 in OpenSSL library
- Fixed occasional Ethernet malfunction
- Fixed occasional failure to send data to Ethernet
- Fixed mobile connection check when setting "enabled + bind"
- Fixed initialization of Fibocom FM101 modules
- Fixed minor issue with 802.1X authentication over Ethernet
- Upgraded library zlib to version 1.2.13
- Upgraded program curl to version 7.86.0
- Upgraded program dnsmasq to version 2.87
- Upgraded program dhcp-isc to version 4.1-ESV-R16-P2
- Upgraded program iptables to version 1.8.8
- Upgraded program keepalived to version 2.2.7
- Upgraded program strongSwan to version 5.9.8
- Upgraded program tcpdump to version 4.99.1
- Upgraded utilities e2fsprogs to version 1.45.7

## v6.3.7 (2022-09-27)

- Add support of Fibocom FM101 modules
- Added support of Quectel BG95 modules
- Added support of Quectel BG96 modules with firmware R03+
- Added support of login banner to SSH server configuration
- Added support of login banner to HTTP server configuration
- Added support of displaying live data in the web interface
- Added package versions to the license list in the web interface
- Added support of license lists in User Modules
- Added possibility to set timeout for command "gsmat"
- Changed internal IP address of Unitac ML620 modules due to collision with 10.0.0.1
- Improved security by running several services in unprivileged mode
- Improved security by generating position-independent code
- Enabled HSTS policy mechanism in case that HTTP access is disabled
- Disabled TLS 1.0 and TLS 1.1 in default configuration
- Removed limitations of configuration parameter length
- Fixed occasional crashing of VRRP daemon
- Fixed several issues in WiFi driver
- Fixed calling  IPsec and OpenVPN up/down scripts in alternative profiles
- Fixed incorrect state of LED1 SIM after startup
- Fixed CVE-2022-1012 in Linux kernel
- Fixed CVE-2022-20368 in Linux kernel
- Fixed CVE-2022-32296 in Linux kernel
- Fixed CVE-2022-36946 in Linux kernel
- Fixed CVE-2022-37434 in library zlib
- Fixed CVE-2022-28391 in program BusyBox
- Replaced package inetutils with pure-ftpd
- Replaced program ndppd with program ndp-proxy
- Upgraded library OpenSSL to version 1.1.1q
- Upgraded library glibc to version 2.35
- Upgrade library tpm2-tss to version 3.2.0
- Upgraded program Net-SNMP to version 5.9.3
- Upgrade program tpm2-tools to version 5.2
- Upgraded program curl to version 7.85.0

## v6.3.6 (2022-06-16)

- Added support of AW-CM358 WiFi modules
- Added support of asymmetric PSK to IPsec configuration
- Added match extension "u32" to iptables
- Improved DHCP server status in web interface
- Fixed connecting to IPv4-only mobile network
- Fixed sending ICMPv6 ping over PPPoE interface
- Fixed resolving IPv6 addresses to MAC addresses
- Fixed occasional stuck of XHCI driver
- Fixed occasional stuck during AP search on SU60 WiFi modules
- Fixed VLAN/VRF ID listing in program "ip"
- Fixed WireGuard service status in the report file
- Fixed issue with Node-RED login
- Upgraded library OpenSSL to version 1.1.1o
- Upgraded program curl to version 7.83.1
- Upgraded program net-snmp to version 5.9.1
- Upgraded program strongSwan to version 5.9.6

## v6.3.5 (2022-04-20)

- Added support of TAP interface to OpenVPN configuration
- Added support of storing system log to eMMC memory
- Added support of changing device ID for remote logging
- Added support of updating firmware in Telit FN980 modules
- Added support for more SFP+ module types to Linux kernel
- Added USB/IP EVEUSB driver to Linux kernel
- Added program "dd" for copying files
- Improved reliability of booting from eMMC memory
- Renamed User Modules to Router Apps
- Fixed connection to a mobile network in IPv6 mode
- Upgraded library zlib to version 1.2.12
- Upgraded library OpenSSL to version 1.1.1n
- Upgraded program OpenVPN to version 2.4.12

## v6.3.4 (2022-02-09)

- Added support of Quectel RM520N modules
- Added support of two-factor authentication
- Added support of second remote IP address to IPsec configuration
- Added support of second remote IP address to OpenVPN configuration
- Added support of user-defined up/down scripts to IPsec configuration
- Added support of user-defined up/down scripts to OpenVPN configuration
- Added support of passphrase to OpenVPN configuration
- Added support of username and password in OpenVPN X.509 multiclient mode
- Added support of setting MTU to IPsec configuration
- Added support of setting MTU on Ethernet interfaces
- Added support of regenerating SSH key
- Added support of automatic redirect to a welcome page
- Added support of resolving "localhost"
- Added invalidation of other active sessions after password change
- Fixed IPsec malfunction when ID does not match certificate subject
- Fixed truncated value of sysObjectID in SNMP response
- Fixed backup of IPv6 up/down scripts during firmware update
- Fixed CVE-2021-20322 in Linux kernel
- Fixed CVE-2021-45485 in Linux kernel
- Fixed CVE-2021-45486 in Linux kernel
- Upgraded library libnl to version 3.2.25
- Upgraded program hostapd to version 2.10
- Upgraded program ppp to version 2.4.9
- Upgraded program strongSwan to version 5.9.5
- Upgraded program wpa_supplicant to version 2.10

## v6.3.3 (2021-12-13)

- Added support of WireGuard VPN
- Added support of Cisco FlexVPN to IPsec
- Added SINR to mobile network status and SNMP mobile subtree
- Added support of waking up from low power mode by RESET button
- Added waiting for RESET button release before resetting
- Renamed menu item "LAN" to "Ethernet" in web interface
- Enabled permanent displaying Location and Name in web interface
- Enabled automatic decrease of MTU value according to mobile network
- Changed default TTL for GRE packets to 64
- Fixed remote access issue when using route-based IPsec
- Fixed entering SIM PIN into Unitac ML620 modules
- Fixed possible reflected XSS attack
- Fixed exit code of program "snmptrap"
- Fixed compatibility of external kernel modules
- Fixed several issues in USB and DMA drivers
- Fixed several issues in I2C driver
- Upgraded firmware in WL1807 WiFi modules to version 8.9.0.0.88
- Upgraded program BusyBox to version 1.34.1
- Upgraded program OpenSSH to version 8.8p1
- Upgraded program strongSwan to version 5.9.4

## v6.3.2 (2021-09-30)

- Added support of WPA3 security
- Added support of SSID isolation
- Added support of Docker
- Added support of PAM
- Added support of Cellient MPL200 modules with firmware MPL200_08_0721
- Added support of ICPlus IP101GR phyter
- Added program "shred"
- Added program "sysctl"
- Added match extension "mark" to ebtables
- Added match extension "addrtype" to iptables
- Added common CA certificates
- Added information about frequency band and signal to SNMP
- Added information about RAM and CPU usage to SNMP
- Enabled SFTP file access logging
- Enabled protection against TCP TIME-WAIT Assassination
- Disabled compression and deprecated ciphers in OpenSSL library
- Improved security of Linux kernel and userspace
- Improved security of HTTP(S)
- Improved security of cookies
- Improved security and interoperability of IPsec
- Increased throughput of Telit FN980 modules
- Switched Telit LE910-NA1 and Quectel EC25-AF modules to "data centric" mode
- Fixed SIM Toolkit activation in Telit LE910-EU V2 modules
- Fixed connection to GPRS networks with LE910-EU V2 modules
- Fixed setting of Perfect Forward Secrecy in IPsec
- Fixed programming of XC-CNT boards
- Fixed CVE-2020-3702 in Linux kernel
- Upgraded library OpenSSL to version 1.1.1l
- Upgraded program curl to version 7.79.1

## v6.3.1 (2021-07-21)

- Added support of the second WiFi module
- Added support of the second binary input to SMS configuration
- Added support of setting MTU and MRU to PPTP configuration
- Added support of setting MTU and MRU to L2TP configuration
- Added support of ICPlus IP101GA phyters
- Added support of Cinterion PLS83 modules with firmware 01.002
- Increased number of firewall rules from 8 to 16
- Fixed checking IPsec SA for multiple tunnels with same IDs
- Fixed wake up from lower power mode
- Fixed WiFi interface statistics
- Fixed CVE-2020-24586 in Linux kernel
- Fixed CVE-2020-24587 in Linux kernel
- Fixed CVE-2020-24588 in Linux kernel
- Fixed CVE-2020-26139 in Linux kernel
- Fixed CVE-2020-26147 in Linux kernel
- Fixed CVE-2020-26558 in Linux kernel
- Fixed CVE-2020-36386 in Linux kernel
- Upgraded driver for SU60 WiFi modules to version 8.5.0.7
- Upgraded firmware in SU60 WiFi modules to version 5.5.38.5
- Upgraded firmware in WL1807 WiFi modules to version 8.9.0.0.86
- Upgraded program dhcp-isc to version 4.1-ESV-R16-P1
- Upgraded program curl to version 7.78.0
- Upgraded program strongSwan to version 5.9.3

## v6.3.0 (2021-05-07)

- Added support of Multi SSID
- Added support of route-based VPN to IPsec
- Added support of certificate-chain validation in IPsec
- Added support of certificate revocation check to IPsec
- Added support of TPM 2.0 chip to IPsec
- Added support of Quectel EM12 modules
- Added more information about connection to NR5G-NSA networks
- Change output of "status" command to show TAC in case of LTE networks
- Changed module shutdown sequence to prevent "call throttled" errors
- Changed remote syslog to use standard RFC 3164 format
- Fixed RS232 hardware flow control
- Downgraded firmware in SD8977 WiFi modules to version 16.68.1.p195
- Upgraded program OpenSSH to version 8.5p1
- Upgraded program OpenVPN to version 2.4.11
- Upgraded program dnsmasq to version 2.85
- Upgraded program strongSwan to version 5.9.2

## v6.2.9 (2021-04-07)

- Added support of Cinterion PLS83 modules
- Added detailed information about the signal to mobile network status
- Added information about frequency band to mobile network status
- Added programs "basename", "cut", "dirname", "printf", "readlink" and "realpath"
- Added JavaScript validation of string inputs
- Changed default APN for PLMN 22603 to "broadband"
- Changed default APN for PLMN 22610 to "net"
- Upgraded library OpenSSL to version 1.1.1k
- Upgraded program curl to version 7.76.0
- Upgraded program ftpd to version 2.0

## v6.2.8 (2021-02-19)

- Added support of Fibocom NL668 modules
- Added support of Unitac ML620 modules
- Added support of Telit LM960 modules
- Added support of Quectel BG96 modules with firmware R02A07+
- Added support of TPM 2.0 chip ST33HTPH
- Added support of tls-crypt mode to OpenVPN configuration
- Added support of setting local IP address to GRE configuration
- Added ability to restrict HTTPS to TLS 1.3
- Added program ebtables
- Added program doas as a replacement for program sudo
- Enabled automatic reboot when all memory is exhausted
- Enabled authoritative mode of DHCP server for WiFi clients
- Extended timeout for NB-IoT network registration
- Fixed several issues in WiFi driver including CVE-2020-36158
- Fixed transmit issues in Laird SU60 WiFi modules
- Fixed resolving of IP address in OpenVPN
- Fixed possible reflected XSS attack
- Upgraded library OpenSSL to version 1.1.1j
- Upgraded program curl to version 7.74.0
- Upgraded program dnsmasq to version 2.84

## v6.2.7 (2020-12-17)

- Added support of Short GI to WiFi AP configuration
- Added support of 80 MHz bandwidth to WiFi AP configuration
- Added support of Hardware UUID
- Added indication of LTE-M and NB-IoT radio access technologies
- Added programs "port1" and "port2" for controlling expansion ports
- Added logging of user authentication failure when accessing the web interface
- Improved identification of router type in the web interface
- Improved permission checking when executing commands like "status"
- Enabled support of POSIX message queues in Linux kernel
- Fixed importing encrypted key from file
- Fixed resetting memories and other components during reboot
- Fixed CVE-2020-10135 in Linux kernel
- Fixed CVE-2020-12351 in Linux kernel
- Fixed CVE-2020-12352 in Linux kernel
- Fixed CVE-2020-24490 in Linux kernel
- Fixed CVE-2020-25705 in Linux kernel
- Upgraded driver for SU60 WiFi modules to version 8.2.0.17
- Upgraded firmware in SU60 WiFi modules to version 5.5.32.5
- Upgraded library OpenSSL to version 1.1.1i
- Upgraded program OpenVPN to version 2.4.10
- Upgraded pam_tacplus plugin to version 1.6.1

## v6.2.6 (2020-09-11)

- Added support of WiFi
- Added support of MTU discovery for BG96 modules
- Added description field for each FW and NAT rule
- Enabled support of Bluetooth in Linux kernel
- Enabled support of VRF Lite in Linux kernel
- Enabled support of UNIX98 pseudoterminals
- Enabled SIM Toolkit on LE910-EU V2 modules
- Changed default APN for PLMN 24007 to "4g.tele2.se"
- Changed default APN for PLMN 45403 to "mobile.three.com.hk"
- Changed default APN for PLMN 42501 and MSIN 9320xxxxxx to "wbdata"
- Improved reading speed from NOR flash memory
- Fixed turning on cellular modules after router power up
- Fixed rare issue when restarting SNMP service
- Fixed erroneous detection of a non-existent phyter
- Upgraded program dnsmasq to version 2.82

## v6.2.5 (2020-06-13)

- Added reading out of PN offset from CDMA modules
- Added support for 802.1X authentication via Ethernet interfaces
- Changed password encryption method from MD5 to SHA256
- Increased maximum number of parameters in a configuration file to 1000
- Improved speed of firmware update
- Disabled autocomplete of password fields
- Hidden sensitive information in web interface
- Fixed crashing of Linux kernel unaligned memory access
- Fixed detection of MRAM during startup
- Fixed detection of MRAM during startup
- Fixed CVE-2019-19447 in Linux kernel
- Upgraded program strongSwan to version 5.8.4

## v6.2.4 (2020-04-25)

- Added support of network type selection
- Added support of SHA384 to IPsec
- Added configuration of restraints for FTP and Telnet
- Added configuration of minimum TLS protocol version
- Added information about misaligned memory access to the report file
- Changed default APN for PLMN 45435 to "wbdata"
- Fixed crashing of Linux kernel during  mobile communication
- Fixed crashing of Linux kernel during WiFi communication
- Fixed performance issues in the third Ethernet driver
- Fixed creating VLANs with ID 1 and 2
- Fixed unlocking and unblocking SIM card
- Fixed information about flags of bridges interfaces
- Fixed CVE-2019-5108 in Linux kernel
- Fixed CVE-2019-18282 in Linux kernel
- Fixed CVE-2020-8597 in program pppd
- Fixed CVE-2018-5388 in program strongSwan
- Fixed CVE-2018-10811 in program strongSwan
- Upgraded program OpenVPN to version 2.4.9
- Upgraded program dhcpcd to version 7.2.5
- Upgraded program dnsmasq to version 2.81
- Upgraded program ftpd to version 1.9.4
- Upgraded program sudo to version 1.8.31

## v6.2.3 (2020-02-11)

- Added checking of DPD delay and DPD timeout in IPsec configuration
- Reworked restarting WiFi so AP and STA are started independently
- Disabled reverse IP lookup in PAM RADIUS plugin
- Disabled reverse IP lookup in FTP server
- Fixed occasional WiFi malfunctions due to wrong IRQ configuration
- Fixed occasional memory leaks in WiFi driver
- Fixed several bugs in VRRP
- Fixed restoring default configuration when RST button is pressed during boot sequence
- Fixed manual assignment of DNS servers for mobile connection
- Fixed processing of very long AT command response
- Fixed initial setup of Cinterion PHS8 modules

## v6.2.2 (2019-12-16)

- Added programs "snmpget" and "snmpset"
- Added support of PAM TACACS+ authentication
- Added taking over of server users during RADIUS/TACACS+ authentication
- Added support of Sierra Wireless EM7565 modules
- Changed default APN for AT&T SIM cards to "broadband"
- Changed default APN for FirstNet SIM cards to "firstnet-broadband"
- Changed format of transferred data in output of "status -v" command
- Increased maximum number of pending TCP connections in HTTP server
- Disabled sending of LCP echo requests to CDMA modules
- Fixed support of Vertex Wireless VWM10 modules
- Fixed support of Cellient MPN100 and MPN200 modules
- Fixed support of Texas Instrument WL1807 modules in multi-role mode
- Fixed detection of link status in Ethernet driver
- Fixed memory access failure when executing programs
- Fixed routing packets over IPsec with overlapping subnets
- Fixed establishing of L2TP tunnel
- Fixed CVE-2019-16275 in program hostapd
- Upgraded program curl to version 7.67.0

## v6.2.1 (2019-10-16)

- Added support of inotify for monitoring filesystem events
- Added support of 64-bit traffic counters
- Fixed counting transferred data over mobile connection
- Fixed processing of non-standard responses to AT commands
- Fixed processing of corrupted bootloader configuration
- Fixed memory access failure when executing programs
- Fixed access to FTP/PPTP server behind NAT
- Fixed crashing of PPTP client
- Fixed crashing of Linux kernel during WiFi restart
- Fixed list of supported 5 GHz WiFi channels
- Fixed setting of Ethernet PHY
- Fixed RS485 direction control for short transfers
- Fixed RS485 direction control during reception
- Fixed CVE-2019-16746 in Linux kernel
- Fixed CVE-2019-17133 in Linux kernel
- Upgraded firmware in WiFi module to version 8.9.0.0.79
- Upgraded library OpenSSL to version 1.0.2t
- Upgraded library libpcap to version 1.9.1
- Upgraded program tcpdump to version 4.9.3

## v6.2.0 (2019-08-16)

- Added support of WiFi
- Added support of WiFi multi-role
- Added support of load balancing
- Added support of interface selection to PPPoE client
- Added support of IEEE 802.1Q to PPPoE client
- Added support of PAM RADIUS authentication
- Added support of hardware flow control
- Added support of loading certificates in PEM format
- Added support of loading certificates in PKCS#12 format
- Added support of VRRPv3 and the second instance
- Changed look of the web interface
- Applied toolchain hardening
- Disabled insecure services in default configuration
- Fixed netmask validation
- Upgraded Linux kernel to version 4.14.138
- Upgraded library glibc to version 2.30
- Upgraded program OpenVPN to version 2.4.7
- Upgraded program curl to version 7.65.3
- Upgraded program sudo to version 1.8.22
- Upgraded program iptables to version 1.4.21
- Upgraded program iproute2 to version 4.14.1
- Upgraded program iw to version 4.14
- Upgraded program hostapd to version 2.9
- Upgraded program wpa_supplicant to version 2.9

## v6.1.10 (2019-07-02)

- Added protection against brute force attacks
- Added filtering out of sensitive data from the report
- Added support of backup and restore of encrypted configuration
- Added support of dynamic starting time of automatic update
- Added dropping SYN packets with suspicious MSS value
- Extended compatibility check of uploaded user modules
- Enabled OpenVPN management interface
- Fixed route selection in Multi WAN mode
- Fixed getting mobile network registration status
- Fixed setting preferred technology
- Fixed reading out technology from Cinterion PLS8 modules
- Fixed sending and receiving SMS from Quectel EC25-AF modules
- Fixed activation of ODIS/DHIR in Quectel EC25-AF modules
- Fixed MBN profile selection for AT&T in Quectel BG96 modules
- Fixed CVE-2019-11477 in Linux kernel
- Fixed CVE-2019-11478 in Linux kernel

## v6.1.9 (2019-04-23)

- Added program "nohup"
- Added program "report"
- Added program "umupdate"
- Added option for selecting interface to program "ping"
- Added support of eMMC 5.1 specification
- Added support of Texas Instruments WL1807 modules
- Added support of Quectel EC25-AF modules
- Added support of ODIS/DHIR
- Added possibility to set timeout for checking connection
- Added possibility to set port range to Firewall and NAT configuration
- Added information about additional interfaces into SNMP
- Modified comparison of firmware versions
- Modified switching to another SIM card after modem hangup
- Modified reconnection mechanism for AT&T network
- Modified reading out ICCID from SIM card
- Increased WiFi throughput
- Increased buffer size for USB bulk transfers
- Fixed setting of PDP context
- Fixed check of IPv6 connection
- Fixed IPv6 prefix delegation
- Fixed detection of RS485
- Fixed switching to lower power mode while binary input is already active
- Fixed JavaScript on page SMTP Configuration
- Fixed JavaScript on page SMS Configuration
- Fixed kernel crash after change of bridge configuration
- Upgraded library OpenSSL to version 1.0.2r
- Upgraded program OpenSSH to version 8.0p1
- Upgraded program curl to version 7.64.1
- Upgraded program dnsmasq to version 2.80
- Upgraded program hostapd to version 2.8
- Upgraded program wpa_supplicant to version 2.8

## v6.1.8 (2018-11-08)

- Added command "sync"
- Added logging of user actions
- Added configuration of syslog service
- Added support of uploading HTTPS certificate
- Added support of mirroring network traffic
- Added information about product type into program "status"
- Added information about expected range of values to web interface
- Changed default APN for PLMN 24202 to "internet.telia.no"
- Fixed selection of PSK for IKEv1 Main Mode
- Fixed update of DynDNS record
- Fixed Multiple WANs mode
- Fixed crashing of DHCP client
- Fixed reading A/D converter values under heavy load
- Fixed LED SIM state after firmware start
- Fixed CVE-2018-14526 in program wpa_supplicant
- Fixed CVE-2018-5391 in Linux kernel
- Upgraded library OpenSSL to version 1.0.2p
- Upgraded program BusyBox to version 1.29.3
- Upgraded program Net-SNMP to version 5.8
- Upgraded program OpenSSH to version 7.9p1
- Upgraded program curl to version 7.62.0

## v6.1.7 (2018-07-25)

- Added digital signature of firmware
- Added match extension "policy" to iptables
- Added displaying of RTC battery status
- Added new options to program "led"
- Added possibility to enable FTP and Telnet services
- Added option "none" to default module selection
- Added support of DNS configuration to PPPoE
- Added support of Sierra Wireless MC7304 modules with firmware 05.05.58
- Removed support of dial-in mode
- Restricted PPPoE bridge mode only to the first module
- Modified authorization of SMS command "REBOOT"
- Modified texts of informational SMS
- Modified SIM cards statistics and connection log
- Modified threshold of good and bad signal level
- Modified restarting of mobile connection
- Modified control of LED WAN
- Modified validation of netmask
- Modified selection of local IP address for IPsec tunnels
- Fixed getting PLMN from Quectel EC25 modules
- Fixed counting of transferred data
- Fixed assignment of IPv6 addresses to cellular modules
- Fixed check of IPv6 connection
- Fixed the first DNS64 translation
- Fixed selection of SNMP trap agent-addr
- Fixed downloading files from FTP server using program "wget"
- Fixed overwriting of parameter PORT_MODE during import of partial configuration
- Fixed check of unsupported WiFi channel
- Fixed several bugs in USB driver
- Upgraded library OpenSSL to version 1.0.2o
- Upgraded program curl to version 7.61.0

## v6.1.6 (2018-03-11)

- Added support of GCM ciphers to IPsec
- Added support of ECP DH groups to IPsec
- Added support of XAUTH to IPsec
- Added support of PubKey to IPsec
- Added support of IKEv2 reauthentication IPsec
- Added program "split"
- Added list of opened TCP and UDP sockets to the report file
- Added information from installed user modules to the report file
- Allowed using special characters in password for new user account
- Changed default APN for PLMN 23201 to "a1.net"
- Increased watchdog timeout
- Improved emergency reboot in case of unrecoverable kernel failure
- Improved throughput of the second Ethernet
- Fixed multiple issues in the second Ethernet driver
- Fixed multiple issues in the third Ethernet driver
- Fixed multiple issues in WiFi driver
- Fixed multiple issues in I2C driver
- Fixed multiple issues in FLASH driver
- Fixed connection to LTE networks
- Fixed random disconnects of LE910 modules
- Fixed setting preferred technology in EC25 modules
- Fixed MAC address in SNMP in case of active VRRP
- Fixed default route switching in Multiple WAN mode
- Fixed static routes via PPPoE and bridged interfaces
- Fixed automatic logout from web interface
- Fixed CVE-2017-18017 in Linux kernel
- Upgraded program curl to version 7.58.0
- Upgraded program dhcp-isc to version 4.1-ESV-R15-P1

## v6.1.5 (2017-12-19)

- Added protocols GRE and ESP to firewall configuration
- Added emergency reboot in case of unrecoverable kernel failure
- Improved speed of SIM card switching
- Improved compatibility of IKEv2 protocol
- Hidden sensitive information in web interface
- Allowed entering empty DHCP lease time
- Fixed WPA2 vulnerabilities
- Fixed detection of USB device speed
- Fixed getting registration status
- Fixed calculation of connection uptime
- Fixed receiving data from LE910 modules
- Fixed RS485 initialization after power up
- Fixed memory leaks in processing fragmented packets
- Fixed multiple issues in the second Ethernet driver
- Fixed multiple issues in the third Ethernet driver
- Fixed multiple issues in WiFi driver
- Upgraded firmware in WiFi module to version 8.9.0.0.76
- Upgraded firmware in WiFi module to version 0.36
- Upgraded library OpenSSL to version 1.0.2n
- Upgraded program OpenSSH to version 7.6p1
- Upgraded program curl to version 7.57.0
- Upgraded program dnsmasq to version 2.78
- Upgraded program hostapd to version 2.6
- Upgraded program wpa_supplicant to version 2.6

## v6.1.4 (2017-09-27)

- Added support of Quectel EC25 modules
- Added support of SMS in Verizon network
- Added missing 5 GHz WiFi bands
- Added timestamps to the kernel log
- Added list of installed user modules to report file
- Added program "top"
- Enabled resizing of "vi" editor window
- Fixed filtering of DNS requests
- Fixed IPsec tunnel termination
- Fixed IPsec tunnel checking mechanism
- Fixed routing IPv6 packets over IPv4 IPsec tunnel
- Fixed removing iptables rules after IPsec termination
- Fixed routing of the second subnet over IPsec tunnel
- Fixed default configuration of OpenVPN  tunnels
- Fixed restarting of SSH server
- Fixed multiple issues in USB driver
- Fixed crash of EHCI driver
- Fixed calculation of connection uptime
- Fixed registration to mobile network with empty name
- Fixed safe shutdown of MPL200 and ME909s modules
- Fixed switching between dial-in and dial-out mode
- Upgraded program OpenVPN to version 2.3.18
- Upgraded program tcpdump to version 4.9.2

## v6.1.3 (2017-08-10)

- Added support of fourth release of Cinterion PLS8 modules
- Added protection against Clickjacking and XSS attacks
- Added wait for firmware update finish to program "reboot"
- Added match extension "statistic" to iptables
- Enabled support of user binaries with Thumb instructions
- Disabled renegotiation of SSL connection
- Fixed registration to unavailable mobile network
- Fixed registration to mobile network after change of MS class
- Fixed reset of mobile statistics at time shift
- Fixed default setting of LE910-NA1 module
- Fixed occasional freezing of communication with MC7710 and MC8705 modules
- Fixed occasional freezing of backup routing daemon
- Fixed multiple issues in WiFi driver
- Fixed setting TX power on WiFi
- Fixed GRE tunnel initialization
- Fixed IPsec tunnel termination
- Fixed crashing of OpenVPN daemon
- Fixed DNS64 translation on interfaces without IPv6 address
- Upgraded program OpenVPN to version 2.3.17
- Upgraded program tcpdump to version 4.9.1

## v6.1.2 (2017-06-12)

- Added support of second Ethernet interface
- Added support of generic CDC-ECM devices
- Added automatic hiding of absent Ethernet interfaces
- Added target "TCPMSS" and match extension "tcpmss" to iptables
- Added programs "cmp", "head" and "wc"
- Added filtering of uploaded files by extension
- Added compatibility check of uploaded user modules
- Added safer cellular module shutdown
- Allowed using empty password for mobile connection
- Changed default APN for PLMN 26201 to "internet.telekom"
- Changed IKEv1 payload order due to better interoperability
- Removed mechanism that causes reboots in case of no mobile connectivity
- Fixed occasional freezing of communication over WiFi
- Fixed occasional freezing of communication with MC7304 and MPL200 modules
- Fixed creating data connection over EC25 module
- Fixed counting TX bytes sent over EC25 module
- Fixed setting of PDP context
- Fixed switching back to default SIM card
- Fixed sending warning SMS after exceeding the data limit
- Fixed terminating of L2TP tunnel
- Fixed terminating of program "nc"
- Fixed CVE-2016-10229 in Linux kernel
- Fixed CVE-2017-5897 in Linux kernel
- Downgraded program iproute2 to version 3.5.0
- Upgraded program OpenVPN to version 2.3.15
- Upgraded program strongSwan to version 5.5.3
- Upgraded program iw to version 3.5
- Upgraded library zlib to version 1.2.11

## v6.1.1 (2017-03-09)

- Added support of Quectel EC25 modules
- Added support of carrier Rogers Wireless
- Added support of static routes
- Added support of backing up and restoring of user accounts
- Added support of L2TP in Linux kernel
- Added match extension "string" to iptables
- Improved security of cookies that are sent over HTTPS connection
- Modified storing content of text areas
- Modified selection of preferred operator
- Fixed receiving packets from cellular module
- Fixed occasional freezing of communication with cellular module
- Fixed counting TX bytes sent over cellular module
- Fixed reading out information from cellular module
- Fixed automatic update of firmware
- Fixed setting of IDs in IPsec when distinguished name is used
- Fixed wrong source IPv6 address in DNS response if VRRP is enabled
- Fixed redirecting services to non-defaults ports
- Fixed buffer overflow in program "status"
- Fixed terminating of "ndppd" daemon
- Fixed CVE-2017-5970 in Linux kernel
- Fixed CVE-2017-6214 in Linux kernel
- Upgraded program tcpdump to version 4.9.0
- Upgraded program OpenSSH to version 7.4p1
- Upgraded library OpenSSL to version 1.0.2k
- Upgraded library glibc to version 2.25

## v6.1.0 (2016-12-15)

- Added support of IKEv2 for IPSec VPN
- Added support of authentication on Ethernet
- Added support of forcing NAT Traversal
- Added support of EAP-TLS authentication on WiFi
- Added support of SCP protocol
- Added support of HTTP protocol
- Added support of HTTP server configuration
- Added support of SSH server configuration
- Added support of Telnet server configuration
- Added support of FTP server configuration
- Added support of unblocking SIM card
- Added program "stty"
- Added target "NFQUEUE" to iptables
- Fixed memory exhaustion in SSH server
- Fixed termination of SSL connection in HTTP server
- Fixed receiving IPv6 packets from cellular module

## v6.0.3 (2016-12-08)

- Added support of IPv6 in Huawei ME909s modules
- Added support of new revision of Telit LE910-NA1 modules
- Added support of manual carrier selection
- Added support of ODIS/DHIR
- Improved IPsec throughput
- Increased size of ICMPv6 packets for checking connection
- Changed name of firmware to "SPECTRE-v3L-LTE-US.bin"
- Fixed counting TX bytes
- Fixed APN provisioning
- Fixed fast SIM card switching
- Fixed switching modules according to LTE signal strength
- Fixed bug in adding an interface to the bridge
- Upgraded program curl to version 7.51.0
- Upgraded program dnsmasq to version 2.76

## v6.0.2 (2016-10-21)

- Added license information
- Added showing error message for unsupported WiFi channels
- Added logging disconnect reason
- Added detection of Verizon SIM cards based on IMSI
- Changed name of router to "SmartFlex"
- Changed name of firmware to "SPECTRE-v3T-LTE.bin"
- Fixed selecting bridged interface with dynamic IP address as backup route
- Fixed priorities for selecting backup route
- Fixed wrong source IP address in DNS response if VRRP is enabled
- Fixed using wrong IP addresses for checking connection
- Fixed multiple issues occurring during WiFi AP restart
- Fixed multiple issues in USB driver
- Fixed multiple issues in DMA driver
- Fixed IPsec daemon crash
- Fixed negotiation of NAT traversal in aggressive mode
- Fixed CVE-2016-7117 in Linux kernel
- Upgraded program conntrack-tools to version 1.0.1
- Upgraded library libnetfilter_conntrack to version 1.0.1
- Upgraded library libnfnetlink  to version 1.0.1
- Upgraded library glibc to version 2.24
- Upgraded library OpenSSL to version 1.0.2j

## v6.0.1 (2016-09-07)

- Added filtering out all forwarded invalid RST and FIN packets
- Reworked firmware update progress indicator
- Increased maximum value of Data Limit to 2 TB
- Increased size of ICMP packets for checking connection
- Changed default APN for PLMN 23820 to "internet.ts.m2m"
- Changed default APN for PLMN 24202 to "tsn"
- Fixed turning on SIM LED after router power up
- Fixed switching SIM card via SMS
- Fixed conversion of Mobile WAN configuration
- Fixed saving carrier selection
- Fixed reconnection mechanism for Verizon network
- Fixed connecting to GPRS/UMTS networks
- Fixed checking connection state
- Fixed reconnect after connection loss
- Fixed setting automatic technology selection
- Fixed setting prefered technology
- Fixed setting PDP authentication parameters
- Fixed reading DNSv6 servers
- Fixed checking of IPv6 backup routes in Multiple WANs mode
- Fixed removing IPv6 addresses from bridged interfaces
- Fixed accepting routes from RA with enabled DHCP
- Fixed setting Media Type on third Ethernet
- Fixed handling premature disconnection of HTTP client
- Fixed reading statistics via SNMP protocol
- Fixed showing information about binary inputs and output
- Fixed CVE-2016-5696 in Linux kernel
- Upgraded program OpenSSH to version 7.3p1
- Upgraded program curl to version 7.50.1

## v6.0.0 (2016-06-29)

- Added support of IPv6
- Added support of client isolation on WiFi
- Added support of client authentication on WiFi
- Added support of controlling RS485 from Linux kernel
- Added support of Multiple WAN
- Removed support of "Extra Options" from IPsec configuration
- Removed program setkey
- Reworked configuration of switching SIM cards
- Reworked configuration and starting VPN tunnels
- Fixed multiple issues in FLASH driver
- Upgraded program iproute to version 3.12.0
- Upgraded program iptables to version 1.4.21

## v5.3.6 (2016-05-31)

- Updated WiFi regulatory database
- Removed support of WiFi channel 14
- Removed support of WiFi channels 12-14 and   setting Country Code
- Fixed support of WiFi DFS for 5 GHz band
- Fixed processing of long response from DynDNS server
- Fixed setting community for 2nd SNMP user after firmware upgrade
- Upgraded program OpenVPN to version 2.3.11
- Upgraded library OpenSSL to version 1.0.2h

## v5.3.5 (2016-05-03)

- Added support of modules Huawei ME909s
- Improved throughput of USB
- Improved throughput of the third Ethernet
- Optimized firmware update
- Changed default APN for PLMN 310410 to "phone"
- Changed parameters for generating HTTPS certificates (V3, SHA2, RSA-2048)
- Disabled weak cipher RC4 in HTTPS server
- Fixed potential vulnerability in HTTP(S) server
- Fixed potential vulnerability in Telnet server
- Fixed login to router from R-WebDog system
- Fixed getting registration status in LTE network
- Fixed decoding phone number in alphanumeric format
- Fixed reading 20-digit ICCID from SIM card
- Fixed initialization of 4th IPsec tunnel
- Fixed CVE-2014-0100 in Linux kernel
- Fixed CVE-2014-0131 in Linux kernel
- Fixed CVE-2014-8160 in Linux kernel
- Fixed CVE-2014-8709 in Linux kernel
- Fixed CVE-2015-1465 in Linux kernel
- Fixed CVE-2015-5364 in Linux kernel
- Fixed CVE-2015-5366 in Linux kernel
- Fixed CVE-2016-0821 in Linux kernel
- Fixed CVE-2014-2706 in Linux kernel
- Upgraded program dhcp-isc to version 4.1-ESV-R13
- Upgraded program OpenSSH to version 7.2p2
- Upgraded library OpenSSL to version 1.0.1t

## v5.3.4 (2016-03-10)

- Added programs "grep", "sed" and "logger"
- Modified firmware name check before update
- Replaced "ext3" filesystem driver with "ext4" driver
- Fixed redirect after login
- Fixed unpacking tar archives with long filenames
- Fixed reading information about connection to mobile network from TRM3 module
- Upgraded library glibc to version 2.23
- Upgraded library OpenSSL to version 1.0.1s

## v5.3.3 (2016-02-12)

- Increased watchdog timeout
- Modified support of expansion board XC3-DUST to reflect hardware changes
- Changed mode for receiving and sending SMS to PDU
- Fixed JFFS2 corruption after read or write failure
- Fixed processing of IPSec packets when subnets are overlapping each other
- Fixed receiving packets with MTU smaller than 1500 bytes
- Upgraded program dhcp-isc to version 4.1-ESV-R12-P1
- Upgraded program OpenSSH to version 7.1p2
- Upgraded library OpenSSL to version 1.0.1r

## v5.3.2 (2015-12-10)

- Added target "CONNMARK" and match extension "connmark" to iptables
- Fixed regression in command "mount"
- Fixed missing CSRF token check
- Fixed redirect back to "LAN Configuration" page after applying changes
- Fixed reading SMS that contains "greater than" sign via AT-SMS protocol
- Fixed displaying Mobile Network Information in PPPoE bridge mode
- Fixed parsing information about connection to LTE network from MPL200 module
- Fixed connecting to LTE network with username and password
- Fixed setting SMS center address
- Fixed IFF_ALLMULTI flag processing in CPSW Ethernet driver
- Fixed switching to low power mode when IN1 is active

## v5.3.1 (2015-10-26)

- Changed absolute URLs to relative in HTTP redirects
- Fixed order of selectable backup routes in backward compatible mode
- Fixed restoring configuration from partial backup
- Fixed getting IP address from third release of Cinterion PLS8 modules
- Fixed initialization of power board PoE PD

## v5.3.0 (2015-10-13)

- Added support of 5 GHz band for WiFi
- Added support of power board PoE PSE
- Added support of 4 OpenVPN tunnels
- Added support of DHCP server on all LAN ports
- Added support of bridge in backup routes
- Added support of multiuser access
- Added CSRF attack protection
- Added passing variables SERVER_ADDR  and SCRIPT_NAME to executed CGI scripts
- Enabled support of high resolution timers in the kernel
- Deactivated second unconnected WiFi antenna
- Updated list of USB/RS-232 converters with chip CP210x
- Changed ARP behaviour (arp_ignore=1, arp_announce=2)
- Changed default APN for PLMN 23420 to "3ireland.ie"
- Changed default APN for PLMN 27202 to "internet"
- Modified router login page
- Modified firmware update page
- Fixed switching backup routers between mobile connection and PPPoE
- Fixed cpdma rx descriptor leak on down interface
- Fixed regression in command "killall"
- Fixed dysfunction of the third Ethernet after electrostatic discharge
- Fixed starting IPsec tunnels under heavy load
- Upgraded program OpenSSH to version 7.1p1
- Upgraded program OpenVPN to version 2.3.8
- Upgraded program Openswan to version 2.6.43.1
- Upgraded program Net-SNMP to version 5.7.3

## v5.2.1 (2015-07-17)

- Enabled support of USB/RS232 converters PL2303
- Enabled support of VRRP protocol
- Prohibited processing DNS TCP request from WAN
- Fixed issue with VRRP MAC address entry in ALE table
- Fixed changing APN in LTE modules
- Fixed rebinding DHCP lease after carrier loss
- Fixed getting IP addresses of DNS servers
- Fixed termination of OpenVPN tunnel
- Fixed stopping VRRP daemon when multiple instances are running
- Downgraded program dhcpcd to version 6.4.7
- Upgraded program dnsmasq to version 2.73
- Upgraded program hostapd to version 2.4
- Upgraded program wpa_supplicant to version 2.4
- Upgraded library OpenSSL to version 1.0.1p

## v5.2.0 (2015-06-09)

- Added support of Sierra Wireless MC7304 modules
- Added support of Cellient MPL200 modules
- Added support of expansion board XC3-DUST
- Added support of second SNMP user
- Added support of caching static files
- Added target "DSCP" and match extension "dscp" to iptables
- Enabled "core dump" creation
- Disabled weak ciphers CBC and RC4 in SSH server
- Disabled weak ciphers CBC, RC4, SEED, CAMELLIA and IDEA in HTTPS server
- Fixed CVE-2013-4345 in Linux kernel
- Fixed CVE-2013-4348 in Linux kernel
- Fixed CVE-2013-7027 in Linux kernel
- Fixed CVE-2014-2706 in Linux kernel
- Fixed CVE-2015-3294 in program dnsmasq
- Fixed potential vulnerability in parsing malformed HTTP request
- Fixed regression in command "ip addr show" that stopped showing IP addresses
- Fixed separation of HTTP headers to comply with RFC 2616
- Fixed filtering of VRRP packets in firewall
- Fixed checking of type of recevied VRRP packets
- Fixed sending of gratuitous ARP packets at state transitions
- Fixed processing unaligned blocks in OMAP AES driver
- Upgraded program BusyBox to version 1.23.2
- Upgraded program OpenSSH to version 6.8p1
- Upgraded program OpenVPN to version 2.3.6
- Upgraded program curl to version 7.42.1
- Upgraded program dhcp-isc to version 4.1-ESV-R11
- Upgraded program dhcpcd to version 6.8.2
- Upgraded program ppp to version 2.4.7
- Upgraded program tcpdump to version 4.7.4
- Upgraded library gmp to version 6.0.0a
- Upgraded library lzo to version 2.09
- Upgraded library pcap to version 1.7.3
- Upgraded library zlib to version 1.2.8
- Replaced program arp with BusyBox applet
- Replaced program brctl with BusyBox applet
- Replaced program vconfig with BusyBox applet

## v5.1.3 (2015-04-24)

- Fixed reading technology from PLS8 modules
- Downgraded OpenSSL to version 1.0.1m

## v5.1.2 (2015-04-09)

- Fixed reading IP addresses of DNS servers from PLS8 modules
- Upgraded OpenSSL to version 1.0.2a

## v5.1.1 (2015-04-01)

- Fixed loading WiFi configuration from alternative profiles
- Fixed mechanism that prevents frequent module shutdowns
- Fixed calculation of network address for third Ethernet

## v5.1.0 (2015-03-16)

- Added support of Cellient MPL200 modules
- Added support of firmware 2.011 in Cinterion PLS8 modules
- Added support of reading ICCID via SNMP protocol
- Added support of reading CSQ via SNMP protocol
- Added support of SHA256 and SHA512 in IPsec tunnels
- Added support of IPsec BEET mode into kernel
- Added parameter "Protocol/Port" to IPsec tunnel configuration
- Added parameter "Inactivity Timeout" to expansion port configuration
- Added selective flush of conntrack table after switching backup route
- Added locking mechanism to avoid multiple start of firmware update
- Added mechanism to recover from deleting configuration
- Added command "ip" which was accidentally dropped in the last version
- Added library libstdc++.so
- Enabled configuration of channel bandwidth  in WiFi STA mode
- Suppressed switching off the first module if GPS is active
- Removed automatic APN detection based on SIM card IMSI code
- Removed support of VRRP protocol
- Fixed issue with flushing multicast entries
- Fixed 5-bits and 6-bits mode on serial line
- Fixed bug that caused disconnecting of Gobi 3000 modul after 10 minutes
- Upgraded OpenSSL to version 1.0.2
- Upgraded glibc to version 2.21
- Upgrade iproute2 to version 3.5.0

## v5.0.0 (2014-12-02)

- Added support of second release of Cinterion PLS8 modules
- Added support of SMTPS
- Added support of chaning SMTP port
- Added support of downloading firmware and configuration from HTTPS/FTPS server
- Added SSH klient
- Added SFTP server
- Added program "curl"
- Added program "find"
- Added program "fwupdate"
- Added program "ip rule"
- Added program "nc"
- Added program "netstat"
- Added program "pidof"
- Added program "xargs"
- Added information about product type into report
- Added automatic closing of SSH connection after 10 minutes of inactivity
- Reduced number of concurrent unauthenticated SSH connections and authentication attempts
- Disabled SSLv3 support in HTTPS protocol
- Enabled change of WEP default key index for WiFi STA mode
- Modified getting of registration state
- Fixed function of XC-ETH in second expansion slot for setting 10 Mbps half duplex
- Fixed getting of MAC address of interface eth0 if VRRP is enabled
- Fixed manual restarting of pppsd service
- Fixed testing of PPP connection using ICMP ping
- Upgraded WPA Supplicant to version 2.0

## v4.0.1 (2014-08-21)

- Added support of Cinterion PLS8 modules
- Added support of Sierra Wireless MC7304 modules
- Added support of DirectIP connection for Sierra Wireless MC8705 modules
- Added support of PPPoE
- Added support of connecting to WiFi network with hidden SSID
- Added logging of network connection failure reason
- Added blocking of incoming traffic on all non-selected backup routes
- Added library libm.so
- Added filesystem devtmpfs
- Reduced SSH login timeout to 1 minute
- Increased maximal length of shell variable to 8 KB
- Removed unnecessary erasing of FLASH during firmware update
- Fixed detection of WiFi module
- Fixed issue with dynamic allocation of pppX interfaces
- Fixed function of XC-ETH in second expansion slot
- Fixed initialization of timer for MACB controller
- Fixed receiving data from serial line
- Fixed reading of SMS when SIM card is full
- Fixed reading SMS from MC7750 module
- Fixed registration to LTE network
- Fixed reading of operator name
- Fixed return to automatic network type selection
- Fixed checking of PPPoE backup route
- Fixed NAT traversal support that was mistakenly removed from Openswan
- Fixed invalid value of SNMP OID mobileDisconnect
- Upgraded driver for Gobi 3000/4000 modules to version S2.18N2.24
- Upgraded ppp to version 2.4.6

## v4.0.0 (2014-04-15)

- Added support of WiFi
- Added support of multicast on GRE tunnels
- Added support of switching back to primary SIM card after timeout even if roaming was detected
- Added password check when remote access is enabled
- Added indication of expansion board XC-SD
- Added passing of interface name to scripts ip-up and ip-down in user modules
- Added default APN "com4" for PLMN 24209
- Added match extension "limit" to iptables
- Added blocking of traffic from module which is not used as default route
- Enhanced configuration of firewall
- Modified initialization of CDMA modules due to issues with newer firmware
- Modified reading of temperature and supply voltage via SNMP protocol
- Modified default APN for PLMN 23205 to "fullspeed"
- Modified displaying of timestamps on page DHCP Status
- Modified value of enterprise OID in SNMP traps
- Enabled SMS reading from module when connection is not established or not in offline mode
- Disabled remote access via SNMP in default configuration
- Prohibited processing DNS request incoming from WAN
- Removed router identification during login process
- Removed automatic reboot due to non-registering to mobile network
- Fixed identification of backup route parameter change
- Fixed online to offline mode change when same SIM card is used
- Fixed VRRP initialization
- Fixed processing of IPSec packets when subnets are overlapping each other
- Fixed damaging of packets that go through GRE tunnel
- Fixed indication of selected SIM card
- Fixed indication of default SIM card
- Fixed reading of signal strength from HC25, EU3 and PHS8 modules
- Fixed reading SMS from PHS8 module
- Updated driver for Gobi 3000/4000 modules to version S2.17N2.23
- Upgraded kernel to version 3.5.0
- Upgraded OpenSSL to version 1.0.1g
- Upgraded OpenSSH to version 6.4p1
- Upgraded OpenVPN to version 2.3.3
- Upgraded OpenSWAN to version 2.6.41
- Upgraded dhcpcd to version 6.2.1
- Upgraded dnsmasq to version 2.68
- Upgraded ftpd to version 1.9.2
- Upgraded ppp to version 2.4.5
- Upgraded pptp to version 1.8.0
- Upgraded pptpd to version 1.4.0
- Upgraded tcpdump to version 4.5.1

## v3.1.1 (2014-05-30)

- Fixed problem with sending/receiving SMS

## v3.1.0 (2014-04-14)

- Fixed initialization of Sierra Wireless MC7750 module

## v3.0.9 (2013-11-20)

- Added program "getty"
- Added support of overriding values from DHCP by settings from configuration
- Added support of PPTP passthrough
- Added temperature and supply voltage to SNMP traps
- Added displaying of network interface flags
- Added passing variables REMOTE_ADDR, REMOTE_USER and HTTP_COOKIE to executed CGI scripts
- Updated driver for Gobi 3000/4000 modules to version S2.11N2.17
- Extended timeout for detecting SIM card status
- Extended timeout for setting preffered operator
- Extended timeout for setting preffered SMS service
- Removed deleting of all iptables rules after configuration change
- Fixed initialization of CDMA modules due to issues with older firmware
- Removed logging of some unimportant warning of program l2tpd
- Fixed bug with long period for connection check after reboot
- Fixed starting of IPsec and OpenVPN tunnels after backup route change

## v3.0.8 (2013-08-30)

- Added individual configuration of ping and DNS server for each SIM card
- Added match extension "pkttype" to iptables
- Added passive check of TCP keepalive expiration
- Added delay before reopening serial line after failure
- Modified reading information about CDMA due to issues with older firmware
- Modified selecting of preffered operator and network type
- Modified selecting of peer IP address of PPP connection
- Modified indication of installed XC-SW expansion board
- Fixed indication of mobile network connection uptime
- Fixed checking of both connections to mobile network in VRRP daemon
- Fixed parsing information about connection to UMTS network from HC25 module
- Fixed decoding of invalid BCD values read out by MBUS protocol

## v3.0.7 (2013-07-12)

- Added support of Cinterion EU3-P modules
- Added support of Cellient MPN100 and MPN200 modules
- Added support of the second RUIM card
- Added support of USB/RS-232 converters FTDI FT232RL, FT232H, FT2232H a FT4232H
- Added support of SNMPv3
- Added support of reading registration status, operator, LAC, signal quality and MEID via SNMP protocol
- Added support of switching between different WAN interfaces
- Added support of choosing IPsec tunnels encryption
- Added support of manual setting of date and time
- Added support of configurable timeouts for each CGI script
- Added new home page
- Added button for creating detailed report
- Added logging of reboot reasons
- Added information about embedded mobile module
- Added more information about mobile network connection
- Added programs "cdmainfo", "cdmaat" and "cdmapwr"
- Added functions for USA certification
- Added filtering of TCP segments FIN and RST not belonging to any active TCP connection
- Added test of functionality of mobile module after its power up
- Added test of RST button before executing system services
- Added target "REJECT" and match extensions "mac" and "quota" to iptables
- Enabled loopback interface
- Enabled automatic correction of misaligned memory access
- Modified detection of signal strength in Sierra Wireless modules
- Modified setting of daylight saving time for USA and Australia
- Modified rejection of TCP connection if checking of TCP connection is enabled
- Modified setting of UDP packet destination port if target IP address is not specified
- Decreaced values of root delay and root dispersion in NTP server
- Increased limits for configuration files (200 lines, 8000 characters per line)
- Disabled reverse DNS lookup in SSH server
- Removed delay before the first control ping
- Fixed crashing of EHCI driver
- Fixed communication problems on second Ethernet
- Fixed communication problems with PHS8 module with GPS
- Fixed processing of multiline response from SMTP server
- Fixed updating of neighbour table
- Fixed receiving of SMS which contains text instead of phone number
- Fixed entering '#' character into username and password
- Fixed setting of preferred network type

## v3.0.6 (2012-10-16)

- Added support of Cinterion PHS8 modules
- Added support of transport mode in IPsec configuration
- Added support of HTTP proxy to OpenVPN
- Added support of reading state of binary outputs and setting state of counters to program "io"
- Added support of executing scripts "install" and "uninstall" in user modules
- Added checking of DirectIP connection
- Added indication of running firmware update via fast flashing of PWR LED
- Added clearing input buffer after accepting new TCP connection in AT-SMS protocol
- Added option "-I" to program ping for selecting outgoing interface
- Added option "-R" to program snmptrap for sending MAC address of interface eth0
- Added program logger
- Changed default APN for PLMN 26201 to "internet.t-mobile"
- Changed texts of automatically generated SMS
- Changed authentification sequence during logging into SMTP server
- Changed processing of packets coming from IPsec tunnel so that they aren't interfered with setting of NAT
- Removed check of minimal hostname length in DynDNS configuration
- Disabled remote access via HTTP, HTTPS, Telnet, SSH and FTP in default configuration
- Prohibited processing DNS request incoming from mobile network
- Decreased working frequency of SMI bus to 40 MHz
- Fixed default setting of shell variable PATH
- Fixed DMA memory leaks
- Fixed counting of sent bytes via interface usb0
- Fixed setting of default gateway

## v3.0.5 (2012-06-05)

- Added support of configuring network bridge
- Added support of setting primary SIM card as backup
- Added support of setting blank APN using keyword "blank"
- Added support of DirectIP connection for Sierra Wireless MC7710 modules
- Added support of USB/RS-232 converter FTDI FT230X
- Added support of reading SN, IMEI, ESN, selected SIM card and assigned IP address via SNMP protocol
- Added support of sending messages to supervisory system via SNMP protocol
- Added support of PIM-SM protocol to Linux kernel
- Added support of commands AT+CMGW, AT+CMSS and AT+COPS? into AT-SMS protocol
- Added processing of LCP Echo Request packets in PPPoE Bridge mode
- Added confirmation dialog when trying to delete module
- Added checking of secondary Ethernet interface IP address
- Added program ftpput
- Added match extension "multiport" to iptables
- Fixed filling timestamp in NTP server reply
- Fixed detection of channel, cell and signal strength in Sierra Wireless modules
- Fixed buffer size in AT-SMS protocol due to sending SMS in PDU format
- Fixed sending SMS containing LF characters
- Fixed automatic updates of DNS proxy after changing DNS servers
- Fixed stopping DHCP client after disconnecting network cable
- Fixed restoring Up/Down scripts in alternative profiles after firmware update

## v3.0.4 (2012-02-06)

- Added support of VLAN (802.1Q)
- Added support of sending SMS messages with time stamp
- Added support of reading temperature and supply voltage via SNMP protocol
- Added support of loading kernel modules and programs insmod and rmmod
- Added checking of filename when upgrading firmware via web interface
- Added checking of downloaded files during automatic firmware update
- Changed length of RSA key for SSH to 1024 bits
- Limited detecting of roaming when establishing PPP connection
- Fixed symlinks when installing user modules
- Fixed sending of long packets on eth1 interface at speed 10 Mbit/s

## v3.0.3 (2011-12-14)

- Added support of QoS
- Added support of PPTP
- Added support of GRE keepalive
- Added signal strength indication via LED PPP
- Added resending SMS after error
- Shortened time to repeat DynDNS record update after server closes connection prematurely
- Fixed termination of OpenVPN after receiving message AUTH_FAILED
- Fixed handling of IPsec packets if Remote IP Address falls within Remote Subnet

## v3.0.2 (2011-11-11)

- Upgraded driver for Sierra Wireless modules to version 1.7.40 to improve transmission speed
- Upgraded Openswan to version 2.6.37
- Upgraded dnsmasq to version 2.59
- Added program for sending SNMP traps
- Added support of using program "restore" to restore configuration from file
- Added support of Sierra Wireless MC8705 modules
- Added support of USB/RS-232 converter CP210x
- Added support of command AT+CSCS into AT-SMS protocol
- Added delay between AT commands into CHAT script to improve stability
- Added automatic reboot at repeated failure of LCP packet transmission
- Modified interval of time synchronization with NTP server from 24 hours to 8 hours
- Fixed starting tunnels when DHCP client is enabled on the first Ethernet

## v3.0.1 (2011-09-26)

- Added SSH server
- Added HTTPS server
- Added programs awk, grep, sed, conntrack and traceroute
- Added support of Marvell 88E6060 switch
- Added possibility to use DTR and CD signals of expansion ports for control and signaling state of TCP connection
- Added showing date and time when listing directory contents via program ls
- Added automatic reboot at lack of system resources
- Replaced shell msh by ash with support for better scripting
- Adjusted generating SPI for IPsec for quicker recovery after reboot
- Fixed router identification in SNMP
- Fixed receiving of multicast frames
- Fixed crashing of VRRP daemon
- Removed password length restrictions

## v3.0.0 (2011-07-27)

- Added support of second expansion port
- Added support of Macronix 25L12835E FLASH memory
- Added support of option "defaults" to initialization scripts of user modules
- Added displaying location and name of router on web interface (from SNMP configuration)
- Added highlighting of menu item "Change Password" when router is using default password
- Fixed processing of UDP packets coming from IPsec tunnel to IP address of interface eth0
- Fixed redirecting TCP port 21 (FTP)
- Fixed detection of HSPA+

## v2.1.2 (2011-06-09)

- Added support of user modules
- Added support of RS-485 to AT-SMS protocol
- Added support of reading GSM statistics via SNMP protocol
- Added detection of addresses of second Ethernet transceiver
- Modified buffer size for receiving SNMP packets
- Modified setting of preferred operator and network type
- Modified location of crontab file
- Fixed automatic update from FTP server
- Fixed sending data to EU3 module via USB
- Fixed reading data from serial line

## v2.1.1 (2011-05-04)

- Fixed setting of system clock source

## v2.1.0 (2011-04-22)

- Added support of selecting both sources for the automatic update
- Added support of selecting DynDNS Server
- Added ability to determine assigned IP address via SMS
- Added timestamps to statistics
- Fixed detecting neighboring channels on UMTS
- Fixed automatic update of configuration
- Fixed reading SMS from EU3 module

## v2.0.9 (2011-03-09)

- Added GSM statistics
- Added info about connection uptime
- Added support of DMA to serial port driver
- Added target "LOG" and match extension "filter" to iptables

## v2.0.8 (2011-02-18)

- Added support of calling scripts when PPP connection is established/lost
- Added information about connection state to SNMP agent
- Added parameter "key" to GRE tunnel configuration
- Modified sending PIN to the module
- Fixed UMTS/GPRS information for Cinterion EU3 module
- Upgraded Kernel to version 2.6.27_stm23_004

## v2.0.7 (2010-12-16)

- Added support of highlighting poor signal quality
- Added support of automatic update via USB flash drive
- Added support of detecting status of analog and counter inputs of XC-CNT expansion board
- Added support of four more NAT rules and possibility to disable masquerade
- Added support of mangle table to iptables
- Added timeout for establishing PPP connection
- Modified accepting of TCP connection when checking of TCP connection is enabled

## v2.0.6 (2010-10-26)

- Added support of periodic time synchronization
- Added support of calling script for processing received SMS
- Fixed starting OpenVPN, IPsec and L2TP tunnels when only one Ethernet port is present
- Fixed restarting of OpenVPN tunnels from web interface
- Fixed entering special characters in password
- Increased limit for parameter Rekey Margin
- Increased timeout for waiting for response from SMTP server

## v2.0.5 (2010-10-05)

- Added support of PPPoE bridge mode
- Added program for sending emails
- Added program for controlling LED USR
- Fixed filtering of Ethernet frames
- Updated APN list

## v2.0.4 (2010-08-31)

- Adjustments for compatibility with new version of Sierra Wireless module

## v2.0.3 (2010-05-26)

- Added support of Cinterion EU3 modules
- Added support of Dynamic DNS in Openswan
- Added support of 802.1d Ethernet Bridging
- Added support of PPPoE
- Added support of copying profiles
- Added support of entering hostname in PPP check configuration
- Added filename check when upgrading firmware
- Added program for controlling inputs and outputs
- Expanded memory area for shell variables
- Fixed getting operator number in roaming
- Fixed showing zero channel number
- Fixed starting automatic update
- Upgraded Openswan to version 2.6.25

## v2.0.2 (2010-02-01)

- Fixed setting of authentication protocol in MC75 modules with firmware older than 04.000

## v2.0.1 (2010-01-27)

- Added program CRON
- Added support of showing transferred data in accounting period
- Added support of Dial-In access
- Added support of setting phone number for Dial-Out and authentication protocol
- Added support of Sierra Wireless MC8700 modules
- Fixed sending frames in driver for Sierra Wireless modules
- Modified restarting IPsec tunnel and packet routing
- Modified entering ping interval (value is in seconds)
- Fixed passing return values of scripts called from CRON daemon

## v2.0.0 (2009-11-19)

- Added support of configuration profiles
- Added support of daylight saving time
- Added support of second OpenVPN tunnel
- Added support of TLS authentication in OpenVPN configuration
- Added support of Dead Peer Detection in IPsec configuration
- Added support of four more NAT rules and configuration of FTP access
- Added support of setting default gateway and DNS server
- Added support of remote logging
- Fixed support of Sierra Wireless module
- Fixed setting of default gateway
- Modified entering PIN
- Upgraded OpenVPN to version 2.1 RC20
