#/bin/bash

if [ -z "$1" ] ; then
    echo "Usage: $0 start|stop|restart"
    exit 1
fi

if [ "$1" != "stop" ] && [ "$1" != "start" ] && [ "$1" != "restart" ];then
    echo "Usage: $0 start|stop|restart"
    exit 1
fi

VPN_NAME=site

env_fix()
{
    sysctl -p /home/sysuser/project/sysctl.conf > /dev/null
    for each in /proc/sys/net/ipv4/conf/*
    do
        echo 0 > $each/accept_redirects
        echo 0 > $each/send_redirects
    done
}

stop_ipsec()
{
	echo "To stop ipsec..."
	ip xfrm state flush
	LINE=`ps aux | grep ipsec | grep -v grep | wc -l`
	if [ "$LINE" = "0" ];then
		echo "no ipsec found"
		return 0
	fi
	/home/sysuser/util/ipsec down $VPN_NAME 2>/dev/null
    /home/sysuser/util/ipsec stop 2>/dev/null
    kill -9 `ps aux | grep ipsec | grep -v grep | awk '{ print $1}'`  2 > /dev/null
	sleep 3
	echo "Stop ipsec end"
}

start_ipsec()
{
	echo "To start ipsec..."
	server_name=`cat /home/sysuser/project/strongswan/ipsec.$VPN_NAME.conf | grep "right=" | awk '{print $1}' | awk -F '=' '{print $2}'`
	/home/sysuser/util/ipsec start
    sleep 2
    /home/sysuser/util/ipsec up $VPN_NAME
    sleep 2
	if [ -n "$server_name" ];then
		line=`ip xfrm state | grep $server_name | wc -l`
		if [ "$line" != "4" ];then
			echo "ipsec connect failed"
			ip xfrm state
			/home/sysuser/util/ipsec statusall $VPN_NAME
			exit 0
		fi
	fi
	echo "Start ipsec end"
}

service_start()
{
	stop_ipsec
	env_fix
	start_ipsec
}

service_stop()
{
	stop_ipsec
}

if [ "$1" == "stop" ];then
	service_stop
fi

if [ "$1" == "start" ];then
	service_start
fi

if [ "$1" == "restart" ];then
	service_stop
	service_start
fi
