#/bin/bash

if [ -z "$1" ] ; then
    echo "Usage: $0 start|stop|restart"
    exit 1
fi

if [ "$1" != "stop" ] && [ "$1" != "start" ] && [ "$1" != "restart" ];then
    echo "Usage: $0 start|stop|restart"
    exit 1
fi

VPN_NAME=myvpn
SERVER_IP=

mkdir -p /var/run/xl2tpd/

valid_ip () {
    local  ip=$1
    local  stat=1

    if [[ $ip =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$ ]]; then
        OIFS=$IFS
        IFS='.'
        ip=($ip)
        IFS=$OIFS
        [[ ${ip[0]} -le 255 && ${ip[1]} -le 255 \
        && ${ip[2]} -le 255 && ${ip[3]} -le 255 ]]
        stat=$?
    fi
    return $stat
}

env_fix()
{
	server_name=`cat /home/sysuser/project/strongswan/ipsec.myvpn.conf | grep "right=" | awk '{print $1}' | awk -F '=' '{print $2}'`
    nslookup -type=a $server_name > /dev/null
    if [ "0" == "$?" ];then
		echo $server_name

		if ! valid_ip $server_name;then
			server_ip=`nslookup -type=a $server_name | grep Address: | tail -1 | awk '{print $2}'`
			if valid_ip $server_ip;then
				set -x
				sed "/right=/c\        right=$server_ip " -i /home/sysuser/project/strongswan/ipsec.myvpn.conf
				sed "s/$server_name/$server_ip/g" -i /home/sysuser/project/strongswan/ipsec.myvpn.secrets
				sed "/lns/c\lns = $server_ip " -i /home/sysuser/project/l2tp/xl2tpd.conf
				echo $server_ip > /etc/ppp/l2tp_server_ip
				set +x
			fi
		else
			echo $server_ip > /etc/ppp/l2tp_server_ip
		fi
		sync
		SERVER_IP=$server_ip
	else
		SERVER_IP=$server_name
    fi

    sysctl -p /home/sysuser/project/sysctl.conf > /dev/null
    for each in /proc/sys/net/ipv4/conf/*
    do
        echo 0 > $each/accept_redirects
        echo 0 > $each/send_redirects
    done
}

stop_ipsec()
{
	echo "To stop ipsec..."
	ip xfrm state flush
	LINE=`ps aux | grep ipsec | grep -v grep | wc -l`
	if [ "$LINE" = "0" ];then
		echo "no ipsec found"
		return 0
	fi
	/home/sysuser/util/ipsec down $VPN_NAME 2>/dev/null
    /home/sysuser/util/ipsec stop 2>/dev/null
    kill -9 `ps aux | grep ipsec | grep -v grep | awk '{ print $1}'`  2 > /dev/null
	sleep 3
	echo "Stop ipsec end"
}

stop_l2tp()
{
	echo "To stop l2tp..."
	ifconfig ppp5 >/dev/null 2>&1
	if [ "$?" = "0" ];then
		ppp-off ppp5 1 > /dev/null 2>/dev/null
	fi
    ps aux | grep -v grep | grep xl2tpd > /dev/null
    if [ "$?" = "0" ];then
      echo "d myvpn" > /var/run/xl2tpd/l2tp-control
	  sleep 2
	  killall xl2tpd 2>/dev/null
	  sleep 1
    fi
	echo "Stop l2tp end"
}

fix_route()
{
	echo "Add $SERVER_IP to route"
	LINE=`ip route show default | head  -1`
	echo $LINE | grep via > /dev/null
	if [ "$?" = "0" ];then
		GW=`echo $LINE | awk '{print $3}'`
		DEV=`echo $LINE | awk '{print $5}'`
	else
		DEV=`echo $LINE | awk '{print $3}'`
		GW="0.0.0.0"
	fi
	echo dev:$DEV gw:$GW
	LINE=`ip route show $SERVER_IP`
	if [ "$LINE"  = "" ];then
		ip route add $SERVER_IP dev $DEV via $GW
	else
		echo "$LINE" | grep $DEV
		if [ "$?" = "0" ];then
			echo "find route in table already"
			echo $LINE
		else
			ip route del $SERVER_IP
			ip route add $SERVER_IP dev $DEV via $GW
			echo "re-add route with new dev"
		fi
	fi
}

start_ipsec()
{
	echo "To start ipsec..."
	/home/sysuser/util/ipsec start
    sleep 2
    /home/sysuser/util/ipsec up $VPN_NAME
    sleep 2
	line=`ip xfrm state | grep $server_name | wc -l`
	if [ "$line" != "4" ];then
		echo "ipsec connect failed"
		ip xfrm state
		/home/sysuser/util/ipsec statusall $VPN_NAME
		exit 0
	fi
	echo "Start ipsec end"
}

start_l2tp()
{
    echo "To start xl2tpd ..."
	fix_route
    /home/sysuser/bin/xl2tpd -c /home/sysuser/project/l2tp/xl2tpd.conf -C /var/run/xl2tpd/l2tp-control
    sleep 2
    echo "To start myvpn"
    echo "c myvpn" > /var/run/xl2tpd/l2tp-control
	sleep 5
	ifconfig ppp5
	if [ "$?" = "0" ];then
		echo "start l2tp success"
	else
		echo "start l2tp failed"
	fi
    echo "start myvpn end"
}

service_start()
{
	stop_l2tp
	env_fix
	start_ipsec
    start_l2tp
}

service_stop()
{
	stop_l2tp
	stop_ipsec
}

if [ "$1" == "stop" ];then
	service_stop
fi

if [ "$1" == "start" ];then
	service_start
fi

if [ "$1" == "restart" ];then
	service_stop
	service_start
fi
