#!/bin/sh

rawurlencode() {                                            
        local string="${1}"                                 
        local strlen=${#string}                             
        local encoded=""                                    
        local pos c o                                       
                                                            
        let strlen=$strlen-1                                
        for pos in $(seq 0 $strlen); do                     
                c=${string:$pos:1}                          
                case "$c" in [-_.~a-zA-Z0-9] )              
                        o="${c}" ;;                         
                * )                                         
                        o=$(printf '%%%02x' "'$c")          
                esac                                        
                                                            
                encoded=$encoded"${o}"                      
        done                                                
        echo "$encoded"                               
}                           

# Returns a string in which the sequences with percent (%) signs followed by
# two hex digits have been replaced with literal characters.
rawurldecode() {

   REPLY="" 
# This is perhaps a risky gambit, but since all escape characters must be
# encoded, we can replace %NN with \xNN and pass the lot to printf -b, which
# will decode hex for us

# You can either set a return variable (FASTER)
  printf -v REPLY '%b' "${1//%/\\x}" 
#+or echo the result (EASIER)... or both... :p
  echo "${REPLY}"
}
url_decode() {
        echo -e "$(echo -n "$1" | sed 's/+/ /g;s/%\(..\)/\\x\1/g;')"
        return 0
}

postdata=$(rawurlencode "{\"body\":\"{\\\"action\\\":102}\",\"channel\":0,\"type\":0}")

[ -f "/tmp/orayboxvpn_connect_status" ] && status=`cat /tmp/orayboxvpn_connect_status`

[ "$status" == "connected" ] && {
	postreturn=$(wget --no-check-certificate --post-data=$postdata http://127.0.0.1:16602/rpccall -q -T 5 -O -)
	echo $(url_decode $postreturn)
	exit 0
}

echo "get_vpn_info failed"
exit 1
