#/bin/sh

if [ -z "$1" ] ; then
    echo "Usage: $0 start|stop|restart"
    exit 1
fi

if [ "$1" != "stop" ] && [ "$1" != "start" ] && [ "$1" != "restart" ];then
    echo "Usage: $0 start|stop|restart"
    exit 1
fi

VPN_NAME=myvpn

mkdir -p /var/run/xl2tpd/

valid_ip () {
    local  ip=$1
    local  stat=1

    if [[ $ip =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$ ]]; then
        OIFS=$IFS
        IFS='.'
        ip=($ip)
        IFS=$OIFS
        [[ ${ip[0]} -le 255 && ${ip[1]} -le 255 \
        && ${ip[2]} -le 255 && ${ip[3]} -le 255 ]]
        stat=$?
    fi
    return $stat
}



stop_l2tp()
{
    ppp-off ppp5 1 > /dev/null 2>/dev/null
    echo "d myvpn" > /var/run/xl2tpd/l2tp-control
    /home/sysuser/bin/ipsec_dir/sbin/ipsec auto --down $VPN_NAME 2>/dev/null
    killall xl2tpd 2>/dev/null
    /home/sysuser/bin/ipsec_dir/init.d/ipsec stop 2>/dev/null
    kill -9 `ps aux | grep ipsec | grep -v grep | awk '{ print $1}'`  2 > /dev/null 
    sleep 3
}

start_l2tp()
{
    server_ip=`cat /home/sysuser/project/l2tp/ipsec.conf | grep "right=" | awk '{print $1}' | awk -F '=' '{print $2}'`
	
	if ! valid_ip $server_ip;then
		server_ip=`nslookup $server_ip | tail -1 | awk '{print $3}'`
		if valid_ip $server_ip;then
			set -x
			sed "/right=/c\        right=$server_ip " -i /home/sysuser/project/l2tp/ipsec.conf
			sed "/lns/c\lns = $server_ip " -i /home/sysuser/project/l2tp/xl2tpd.conf
			echo $server_ip > /etc/ppp/l2tp_server_ip
			set +x
		fi
	else
		echo $server_ip > /etc/ppp/l2tp_server_ip
	fi
	
	sync

    sysctl -p /home/sysuser/project/sysctl.conf
    for each in /proc/sys/net/ipv4/conf/*
    do
        echo 0 > $each/accept_redirects
        echo 0 > $each/send_redirects
    done

    /home/sysuser/bin/ipsec_dir/init.d/ipsec start
    sleep 5
    /home/sysuser/bin/ipsec_dir/sbin/ipsec auto --up $VPN_NAME
    /home/sysuser/bin/xl2tpd -c /home/sysuser/project/l2tp/xl2tpd.conf -C /var/run/xl2tpd/l2tp-control 
    sleep 1 
    echo "c myvpn" > /var/run/xl2tpd/l2tp-control

}


if [ "$1" == "stop" ];then
   stop_l2tp
fi

if [ "$1" == "start" ];then 
    start_l2tp
fi

if [ "$1" == "restart" ];then 
   stop_l2tp
   start_l2tp
fi
