#!/bin/bash
HOST=`hostname`
BASE=/home/sysuer/
OUTFILE=webserver.pem
DAYS=10950

if [ -n "$1" ];then
BASE="$1"
fi
OUTFILE=${BASE}/project/webserver.pem

if [ -f ${OUTFILE} ];then
	openssl verify -CAfile ${OUTFILE} ${OUTFILE}
	if [ "$?" != "0" ];then
		rm -rf ${OUTFILE}
	fi
fi

if [ ! -f ${OUTFILE} ];then
	openssl req -sha256 -newkey rsa:2048 -nodes -keyout ${OUTFILE} -x509 -days ${DAYS} -out ${OUTFILE} -outform PEM  -subj /CN=${HOST}/
	chmod 0777 ${OUTFILE}
fi
