#!/bin/bash

if [ -z "$1" ] ; then
    echo "Usage: $0 config_path|stop"
    echo "Example: $0 /etc/firewall"
    echo "Example: $0 stop"
    exit 1
fi

if [ "$1" != "stop" ]; then
    CONFIG_PATH=$1
fi

IPT=/sbin/iptables
MOD=modprobe
CTL=sysctl

LO_IFACE="lo"
LO_IP="127.0.0.1"

MODNAME=EdgeLink
MODULE_CHAIN=mod_$MODNAME

#$MOD ip_tables
#$MOD ip_conntrack
#$MOD ipt_REJECT
#$MOD ipt_LOG
#$MOD ipt_iprange
#$MOD xt_tcpudp
#$MOD xt_state
#$MOD xt_multiport

#$CTL -w net.ipv4.ip_forward=1 > /dev/null 2>&1
#$CTL -w net.ipv4.ip_default_ttl=128  > /dev/null 2>&1
#$CTL -w net.ipv4.icmp_echo_ignore_all=1 > /dev/null 2>&1
#$CTL -w net.ipv4.icmp_echo_ignore_broadcasts=1 > /dev/null 2>&1

echo "Flushing Tables ..."

# Reset Default Policies
#$IPT -P INPUT ACCEPT
#$IPT -P FORWARD ACCEPT
#$IPT -P OUTPUT ACCEPT
#$IPT -t nat -P PREROUTING ACCEPT
#$IPT -t nat -P POSTROUTING ACCEPT
#$IPT -t nat -P OUTPUT ACCEPT
#$IPT -t mangle -P PREROUTING ACCEPT
#$IPT -t mangle -P OUTPUT ACCEPT

# Flush all rules
#$IPT -F
#$IPT -t nat -F
#$IPT -t mangle -F

# Erase all non-default chains
#$IPT -X
#$IPT -t nat -X
#$IPT -t mangle -X

/sbin/iptables -F $MODULE_CHAIN >/dev/null


#iptables-restore -n < /etc/iptables.up.rules
if [ "$1" = "stop" ]; then
    echo "Firewall completely flushed!  Now running with no firewall."
    exit 0
fi

if [ -e "${CONFIG_PATH}/AdvProgramMgr.acr" ];then
	cat ${CONFIG_PATH}/AdvProgramMgr.acr | grep -v "#" | grep "firewall.sh stop"
	if [ "$?" = "0" ]; then
		echo "AdvProgramMgr.acr stop firewall!  Now running with no firewall."
		exit 0
	fi
fi

PORT_WHITE_LIST="$CONFIG_PATH/port_allow.lst"
PORT_BLACK_LIST="$CONFIG_PATH/port_deny.lst"


if [[ ! -e "${PORT_WHITE_LIST}" ]] && [[ ! -e "${PORT_BLACK_LIST}" ]];then
	echo "port_allow.lst and port_deny.lst not exist !  Now running with no firewall."
	exit 0
fi

# Set Policies

#$IPT -P INPUT DROP
#$IPT -P OUTPUT DROP
#$IPT -P FORWARD DROP
#$IPT -A INPUT -m state --state ESTABLISHED -j ACCEPT -m comment --comment "dE3bE0jA0a"

# INPUT Chain
# Localhost
#$IPT -A INPUT -p ALL -i $LO_IFACE -j ACCEPT -m comment --comment "dE3bE0jA0a"


if [ -f $PORT_WHITE_LIST ]; then
cat $PORT_WHITE_LIST | grep -v "#" | while read i
do
    PORT_PROTO=$i
    PORT=`echo $PORT_PROTO|awk -F "|" '{print $1}'`
    PROTO=`echo $PORT_PROTO|awk -F "|" '{print $2}'`
    IFACE=`echo $PORT_PROTO|awk -F "|" '{print $3}'`
    IP=`echo $PORT_PROTO|awk -F "|" '{print $4}'`

    if [[ $PORT =~ "," ]] || [[ $PORT =~ ":" ]]; then
    PORT_OPT="--dports $PORT"
	MATCH_OPT="-m multiport"
	else
	PORT_OPT="--dport $PORT"
	MATCH_OPT=""
    fi

    if [ "$PROTO" != "all" ]; then
        PROTO_OPT="-p $PROTO"
        MATCH_OPT="${MATCH_OPT} -m $PROTO"
    fi

    if [ $PROTO = "icmp" ]; then
    	PORT_OPT="--icmp-type $PORT"
    	MATCH_OPT="-m $PROTO"
    fi

    if [[ $IFACE = "" ]] || [[ $IFACE = "all" ]]; then
        IFACE_OPT=""
    else
		IFACE_OPT="-i $IFACE"
    fi

    if [[ $IP = "" ]] || [[ $IP = "all" ]]; then
        IP_OPT=""
    else
        IP_VAR=`echo $IP | awk '{print $1}'`
        if [[ $IP_VAR = "iprange" ]]; then
	    IP_OPT="-m $IP"
        else
	    IP_OPT="-s $IP"
        fi
    fi
    if [ $PROTO != "all" ]; then
    	$IPT -I $MODULE_CHAIN $PROTO_OPT $MATCH_OPT $PORT_OPT $IFACE_OPT $IP_OPT -j ACCEPT
    else
	    PROTO_OPT="-p tcp"
	    MATCH_OPT1="${MATCH_OPT} -m tcp"
	    $IPT -I $MODULE_CHAIN $PROTO_OPT $MATCH_OPT $PORT_OPT $IFACE_OPT $IP_OPT -j ACCEPT
	    PROTO_OPT="-p udp"
	    MATCH_OPT1="${MATCH_OPT} -m udp"
	    $IPT -I $MODULE_CHAIN $PROTO_OPT $MATCH_OPT1 $PORT_OPT $IFACE_OPT $IP_OPT -j ACCEPT
    fi
done
fi

exit 0

