#!/bin/sh

MODULENAME=mb2mqtt
MODULEPATH=/opt/${MODULENAME}
SETTINGSFILE=$MODULEPATH/etc/settings
MODLOG=/tmp/$MODULENAME/$MODULENAME.log

exe_start="$MODULEPATH/etc/init start"
while true
do
    MB2MQTT_EN=`cat "$SETTINGSFILE" | grep MB2MQTT_ENABLE)`
    MB2MQTT_EN=${MB2MQTT_EN#*=}
    [ "$MB2MQTT_EN" == "1" ] || exit 0

    sleep 5

    alive=$(ps | grep -w $MODULENAME | grep -v grep | grep -v poll_mb2mqtt.sh | wc -l)
    [ "$alive" == "0" ] && {
        echo "mb2mqtt is not alive, run again." >> $MODLOG
        $exe_start &
    }
done
