#!/bin/sh

# Initialize library
MOD_CP_LIB=/opt/captive_portal/usr/libexec/functions
[ -f "$MOD_CP_LIB" ] || exit 2
. $MOD_CP_LIB

# After HTTP GET the $QUERY_STRING is already set by the server
# After HTTP POST, read stdin to $QUERY_STRING
if [ "x$REQUEST_METHOD" == "xPOST" ]; then
  read -n $CONTENT_LENGTH QUERY_STRING
fi

# Verify hash authentication
auth_hash_verify()
{
  SALT_FILE="$MOD_CP_SALT_DIR/$REMOTE_ADDR"
  [ -f "$SALT_FILE" ] || return 2
  R=1
  while read AUTH_SALT; do
    MY_HASH=`echo -n "$AUTH_SALT$MOD_CP_AUTH_USER$MOD_CP_AUTH_PASS" | openssl dgst -md5 | awk '/stdin/ {print $2} !/stdin/ {print}'`
    if [ "$MY_HASH" = "$1" ]; then
      R=0
      break
    fi
  done < $SALT_FILE
  rm -f $SALT_FILE
  return $R
}

# Get original URL
ORIGIN_URL=`query_value_get "$QUERY_STRING" "origin_url"`
if [ -z "$ORIGIN_URL" ]; then
  ORIGIN_URL=`query_value_get "$HTTP_REFERER" "origin_url"`
  [ -n "$ORIGIN_URL" ] || exit 3
fi

# Get username and password
LOGIN_RESULT=0
if [ $MOD_CP_AUTH_ENABLED -ne 0 ]; then
  AUTH_HASH=`query_value_get "$QUERY_STRING" "auth_hash"`
  if [ -n "$AUTH_HASH" ]; then
    # hash authentication
    auth_hash_verify "$AUTH_HASH"
    LOGIN_RESULT=$?
  else
    # plain username/password authentication
    AUTH_USER=`query_value_get "$QUERY_STRING" "auth_user"`
    AUTH_PASS=`query_value_get "$QUERY_STRING" "auth_pass"`
    if [ "x$AUTH_USER" != "x$MOD_CP_AUTH_USER" -o "x$AUTH_PASS" != "x$MOD_CP_AUTH_PASS" ]; then
      LOGIN_RESULT=1
    fi
  fi
fi

# Customer login
if [ $LOGIN_RESULT -eq 0 ]; then
  $MOD_CP_LIB_DIR/cust login $REMOTE_ADDR "$ORIGIN_URL" "$HTTP_USER_AGENT" >/dev/null 2>&1
fi

# Redirect to original URL
ORIGIN_URL=`url_decode "$ORIGIN_URL"`
echo "HTTP/1.1 200 OK"
echo "Content-Type: text/html; charset=UTF-8"
echo "Refresh: 3; url=$ORIGIN_URL"
echo "Connection: Close"
echo
echo "<html>"
echo "  <body>"
echo "    <div align=\"center\">"
if [ $LOGIN_RESULT -eq 0 ]; then
echo "      <h1>Success</h1>"
else
echo "      <h1>Failure</h1>"
fi
echo "    </div>"
echo "  </body>"
echo "</html>"
