#!/bin/sh

# Initialize library
MOD_CP_LIB=/opt/captive_portal/usr/libexec/functions
[ -f "$MOD_CP_LIB" ] || exit 2
. $MOD_CP_LIB
# WP
if [ "$MOD_CP_WP_ENABLED" = "1" ] && [ -n "$MOD_CP_WP_URL" ] && [ "$MOD_CP_WP_MODE" = "rproxy" ]; then
  WP_URL="$MOD_CP_WP_URL"
  CLI_MAC=`ip2mac $REMOTE_ADDR`
  EXTRA_PARAMS="&client_mac=$CLI_MAC&client_ip=$REMOTE_ADDR&ap_mac=$PUBLIC_IF_MAC&ap_ip=$PUBLIC_IF_IP&ap_ssid=$PUBLIC_IF_SSID"
else
  WP_URL=`page_name_get "index" "$MOD_CP_WWW_DIR"`
  EXTRA_PARAMS=''
fi
# Prepare original URL
if [ "$MOD_CP_WP_ENABLED" = "1" ] && [ -n "$MOD_CP_WP_URL" ] && [ "$MOD_CP_WP_MODE" = "redirect" ]; then
   # redirect to wp only
  ORIGIN_URL="$MOD_CP_WP_URL"
else
  ORIGIN_URL=`url_encode "http://$HTTP_HOST$REQUEST_URI"`
fi
# Show welcome page
echo "Status: 302"
echo "Content-Type: text/html; charset=utf-8"
echo "Cache-Control: no-cache, no-store, must-revalidate" # HTTP 1.1
echo "Pragma: no-cache" # HTTP 1.0
echo "Expires: 0" # Proxies
echo "Location: $WP_URL?origin_url=$ORIGIN_URL$EXTRA_PARAMS"
echo
